/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.enums.Channel;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.FilterArgument;

public class AudioFilterJoin
implements AudioFilterSupplier {
    private final int inputs;
    private final ChannelLayout channelLayout;
    private final Map<Channel, String> sourceByDestChannel;
    private final List<Channel> destChannelList;

    public AudioFilterJoin(int inputs, ChannelLayout channelLayout, Map<Channel, String> sourceByDestChannel) {
        this.inputs = inputs;
        this.channelLayout = channelLayout;
        this.sourceByDestChannel = sourceByDestChannel;
        this.destChannelList = channelLayout.getChannelList();
        if (sourceByDestChannel.size() != this.destChannelList.size()) {
            throw new IllegalArgumentException("Invalid channel count (layout <-> map)");
        }
        if (!this.destChannelList.stream().allMatch(sourceByDestChannel::containsKey)) {
            throw new IllegalArgumentException("Missing channel(s) in map. You need only " + this.destChannelList);
        }
    }

    @Override
    public Filter toFilter() {
        String map = this.destChannelList.stream().map(channel -> {
            String dest = this.sourceByDestChannel.get(channel);
            return dest.replace(':', '.') + "-" + channel.toString();
        }).collect(Collectors.joining("|"));
        return new Filter("join", new FilterArgument("inputs", this.inputs), new FilterArgument("channel_layout", this.channelLayout), new FilterArgument("map", map));
    }
}

