/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.filtering.FilterAddArgumentTrait;
import tv.hd3g.fflauncher.filtering.FilterAddOptionalArgumentTrait;
import tv.hd3g.fflauncher.filtering.FilterArgument;
import tv.hd3g.fflauncher.filtering.parser.FilterParser;
import tv.hd3g.fflauncher.filtering.parser.FilterParserDefinition;

public class Filter
implements FilterParserDefinition,
FilterAddArgumentTrait,
FilterAddOptionalArgumentTrait {
    private List<String> sourceBlocks;
    private List<String> destBlocks;
    private String filterName;
    private List<FilterArgument> arguments;

    public Filter(String rawFilter) {
        List<List<Filter>> items = FilterParser.fullParsing(rawFilter, () -> this);
        if (items.size() > 1 || items.get(0).size() > 1) {
            throw new IllegalArgumentException("This is filter chain, not a simple filter: " + rawFilter);
        }
    }

    Filter() {
    }

    public Filter(String filterName, Collection<FilterArgument> arguments) {
        this.filterName = filterName;
        this.arguments = new ArrayList<FilterArgument>(arguments);
        this.sourceBlocks = new ArrayList<String>();
        this.destBlocks = new ArrayList<String>();
    }

    public Filter(String filterName, FilterArgument ... arguments) {
        this.filterName = filterName;
        for (int pos = 0; pos < arguments.length; ++pos) {
            Objects.requireNonNull(arguments[pos], "arguments can't contain null elements: #" + pos);
        }
        this.arguments = new ArrayList<FilterArgument>(List.of(arguments));
        this.sourceBlocks = new ArrayList<String>();
        this.destBlocks = new ArrayList<String>();
    }

    public String toString() {
        Object argumentItems;
        Object dest;
        Collector<CharSequence, ?, String> ioBlocksJoiner = Collectors.joining("][");
        Object sources = this.sourceBlocks.stream().collect(ioBlocksJoiner);
        if (!((String)sources).isEmpty()) {
            sources = "[" + (String)sources + "]";
        }
        if (!((String)(dest = this.destBlocks.stream().collect(ioBlocksJoiner))).isEmpty()) {
            dest = "[" + (String)dest + "]";
        }
        if (!((String)(argumentItems = this.arguments.stream().map(FilterArgument::toString).collect(Collectors.joining(":")))).isEmpty()) {
            argumentItems = "=" + (String)argumentItems;
        }
        return (String)sources + this.filterName + (String)argumentItems + (String)dest;
    }

    @Override
    public void setSourceBlocks(List<String> sourceBlocks) {
        this.sourceBlocks = Objects.requireNonNull(sourceBlocks);
    }

    @Override
    public void setDestBlocks(List<String> destBlocks) {
        this.destBlocks = Objects.requireNonNull(destBlocks);
    }

    @Override
    public void setFilterName(String filterName) {
        this.filterName = Objects.requireNonNull(filterName);
    }

    @Override
    public void setArguments(List<FilterArgument> arguments) {
        this.arguments = Objects.requireNonNull(arguments);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$sourceBlocks = this.getSourceBlocks();
        List<String> other$sourceBlocks = other.getSourceBlocks();
        if (this$sourceBlocks == null ? other$sourceBlocks != null : !((Object)this$sourceBlocks).equals(other$sourceBlocks)) {
            return false;
        }
        List<String> this$destBlocks = this.getDestBlocks();
        List<String> other$destBlocks = other.getDestBlocks();
        if (this$destBlocks == null ? other$destBlocks != null : !((Object)this$destBlocks).equals(other$destBlocks)) {
            return false;
        }
        String this$filterName = this.getFilterName();
        String other$filterName = other.getFilterName();
        if (this$filterName == null ? other$filterName != null : !this$filterName.equals(other$filterName)) {
            return false;
        }
        List<FilterArgument> this$arguments = this.getArguments();
        List<FilterArgument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Filter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $sourceBlocks = this.getSourceBlocks();
        result = result * 59 + ($sourceBlocks == null ? 43 : ((Object)$sourceBlocks).hashCode());
        List<String> $destBlocks = this.getDestBlocks();
        result = result * 59 + ($destBlocks == null ? 43 : ((Object)$destBlocks).hashCode());
        String $filterName = this.getFilterName();
        result = result * 59 + ($filterName == null ? 43 : $filterName.hashCode());
        List<FilterArgument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public List<String> getSourceBlocks() {
        return this.sourceBlocks;
    }

    public List<String> getDestBlocks() {
        return this.destBlocks;
    }

    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public List<FilterArgument> getArguments() {
        return this.arguments;
    }
}

