/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Locale;
import java.util.Optional;
import tv.hd3g.fflauncher.filtering.FilterAddArgumentTrait;

public interface FilterAddOptionalArgumentTrait
extends FilterAddArgumentTrait {
    default public void addOptionalArgument(String key, String value) {
        if (key != null && value != null) {
            this.addArgument(key, value);
        }
    }

    default public void addOptionalArgument(String key, Number value) {
        if (key != null && value != null) {
            this.addArgument(key, value);
        }
    }

    default public void addOptionalArgument(String key, Enum<?> value) {
        if (key != null && value != null) {
            this.addArgument(key, value);
        }
    }

    default public void addOptionalArgument(String key) {
        if (key != null) {
            this.addArgument(key);
        }
    }

    default public void addOptionalArgument(String key, boolean add) {
        if (key != null && add) {
            this.addArgument(key);
        }
    }

    default public void addOptionalDurationSecArgument(String key, Duration duration) {
        if (key != null && duration != null) {
            this.addArgument(key, duration.toSeconds());
        }
    }

    default public String roundWithPrecision(double number) {
        DecimalFormat dfMs = new DecimalFormat("#.###");
        dfMs.setRoundingMode(RoundingMode.CEILING);
        dfMs.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        return dfMs.format(number);
    }

    default public void addOptionalDurationSecMsArgument(String key, Duration duration) {
        if (key != null && duration != null) {
            this.addArgument(key, this.roundWithPrecision((double)duration.toMillis() / 1000.0));
        }
    }

    default public <T> void addArgument(String key, Optional<T> value) {
        if (key != null && value.isPresent()) {
            this.addArgument(key, String.valueOf(value.get()));
        }
    }

    default public void addOptionalArgument(String key, boolean add, String value) {
        if (key != null && add && value != null) {
            this.addArgument(key, value);
        }
    }

    default public void addOptionalNonNegativeArgument(String key, int value) {
        if (key != null && value > -1) {
            this.addArgument(key, value);
        }
    }

    default public void addOptionalNonNegativeArgument(String key, long value) {
        if (key != null && value > -1L) {
            this.addArgument(key, value);
        }
    }

    default public void addOptionalNonNegativeArgument(String key, float value) {
        if (key != null && Math.signum(value) >= 0.0f) {
            this.addArgument(key, this.roundWithPrecision(value));
        }
    }

    default public void addOptionalNonNegativeArgument(String key, double value) {
        if (key != null && Math.signum(value) >= 0.0) {
            this.addArgument(key, this.roundWithPrecision(value));
        }
    }
}

