/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;

public class VideoFilterIdet
implements VideoFilterSupplier {
    private float intlThres = -1.0f;
    private float progThres = -1.0f;
    private float repThres = -1.0f;
    private int halfLife = -1;
    private boolean analyzeInterlacedFlag;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("idet");
        f.addOptionalArgument("analyze_interlaced_flag", this.analyzeInterlacedFlag, "1");
        f.addOptionalNonNegativeArgument("intl_thres", this.intlThres);
        f.addOptionalNonNegativeArgument("prog_thres", this.progThres);
        f.addOptionalNonNegativeArgument("half_life", this.halfLife);
        return f;
    }

    public float getIntlThres() {
        return this.intlThres;
    }

    public float getProgThres() {
        return this.progThres;
    }

    public float getRepThres() {
        return this.repThres;
    }

    public int getHalfLife() {
        return this.halfLife;
    }

    public boolean isAnalyzeInterlacedFlag() {
        return this.analyzeInterlacedFlag;
    }

    public void setIntlThres(float intlThres) {
        this.intlThres = intlThres;
    }

    public void setProgThres(float progThres) {
        this.progThres = progThres;
    }

    public void setRepThres(float repThres) {
        this.repThres = repThres;
    }

    public void setHalfLife(int halfLife) {
        this.halfLife = halfLife;
    }

    public void setAnalyzeInterlacedFlag(boolean analyzeInterlacedFlag) {
        this.analyzeInterlacedFlag = analyzeInterlacedFlag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoFilterIdet)) {
            return false;
        }
        VideoFilterIdet other = (VideoFilterIdet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getIntlThres(), other.getIntlThres()) != 0) {
            return false;
        }
        if (Float.compare(this.getProgThres(), other.getProgThres()) != 0) {
            return false;
        }
        if (Float.compare(this.getRepThres(), other.getRepThres()) != 0) {
            return false;
        }
        if (this.getHalfLife() != other.getHalfLife()) {
            return false;
        }
        return this.isAnalyzeInterlacedFlag() == other.isAnalyzeInterlacedFlag();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoFilterIdet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getIntlThres());
        result = result * 59 + Float.floatToIntBits(this.getProgThres());
        result = result * 59 + Float.floatToIntBits(this.getRepThres());
        result = result * 59 + this.getHalfLife();
        result = result * 59 + (this.isAnalyzeInterlacedFlag() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "VideoFilterIdet(intlThres=" + this.getIntlThres() + ", progThres=" + this.getProgThres() + ", repThres=" + this.getRepThres() + ", halfLife=" + this.getHalfLife() + ", analyzeInterlacedFlag=" + this.isAnalyzeInterlacedFlag() + ")";
    }
}

