/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.parser;

import java.util.Objects;

final class FilterParserChars {
    private final char[] entries;
    private final boolean escaped;

    FilterParserChars(char entry) {
        this.entries = new char[]{entry};
        this.escaped = false;
    }

    FilterParserChars(char entry, boolean escaped) {
        this.entries = new char[]{entry};
        this.escaped = escaped;
    }

    FilterParserChars(CharSequence chars) {
        Objects.requireNonNull(chars, "\"chars\" can't to be null");
        if (chars.length() == 0) {
            throw new IndexOutOfBoundsException("Can't manage empty chars");
        }
        char[] list = new char[chars.length()];
        for (int pos = 0; pos < list.length; ++pos) {
            list[pos] = chars.charAt(pos);
        }
        this.entries = list;
        this.escaped = false;
    }

    void write(StringBuilder sb) {
        if (this.escaped) {
            sb.append("\\");
        }
        sb.append(this.entries);
    }

    public String toString() {
        if (this.escaped) {
            return "\\" + String.valueOf(this.entries);
        }
        return String.valueOf(this.entries);
    }

    boolean isComma() {
        return !this.escaped && this.entries[0] == ',';
    }

    boolean isColon() {
        return !this.escaped && this.entries[0] == ':';
    }

    boolean isSemicolon() {
        return !this.escaped && this.entries[0] == ';';
    }

    boolean isBracketOpen() {
        return !this.escaped && this.entries[0] == '[';
    }

    boolean isBracketClose() {
        return !this.escaped && this.entries[0] == ']';
    }

    boolean isEquals() {
        return !this.escaped && this.entries[0] == '=';
    }

    boolean isFromEscaped() {
        return this.escaped;
    }
}

