/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.progress;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.fflauncher.progress.AtomicLatchReference;
import tv.hd3g.fflauncher.progress.ProgressBlock;
import tv.hd3g.fflauncher.progress.ProgressCallback;

public class ProgressListenerSession {
    private static final Logger log = LoggerFactory.getLogger(ProgressListenerSession.class);
    public static final String LOCALHOST_IPV4 = "127.0.0.1";
    private final Thread currentThread;
    private final ProgressCallback progressCallback;
    private final Duration statsPeriod;
    private final AtomicLatchReference<ServerSocket> serverSocketReference;
    private final AtomicLatchReference<Socket> clientSocketReference;

    ProgressListenerSession(ThreadFactory threadFactory, ProgressCallback progressCallback, Duration statsPeriod) {
        Objects.requireNonNull(threadFactory);
        this.progressCallback = Objects.requireNonNull(progressCallback, "\"progressCallback\" can't to be null");
        this.statsPeriod = Objects.requireNonNull(statsPeriod, "\"statsPeriod\" can't to be null");
        this.currentThread = threadFactory.newThread(this::listen);
        this.serverSocketReference = new AtomicLatchReference();
        this.clientSocketReference = new AtomicLatchReference();
    }

    public int start() {
        if (!this.currentThread.isAlive()) {
            if (this.currentThread.getState() == Thread.State.TERMINATED) {
                throw new IllegalStateException("Server Thread is now terminated");
            }
            this.currentThread.start();
        }
        return this.serverSocketReference.get(1L, TimeUnit.SECONDS).getLocalPort();
    }

    private void listen() {
        int localport = 0;
        try (ServerSocket server = this.createServerSocket();){
            SocketAddress localSocketAddress = server.getLocalSocketAddress();
            log.debug("Socket listen now to {}...", (Object)localSocketAddress);
            this.serverSocketReference.set(server);
            localport = server.getLocalPort();
            this.progressCallback.onStartProgressListener(localport);
            try (Socket clientSocket = server.accept();){
                int size;
                log.debug("Client (ffmpeg?) is now connected on {}, wait to receive progress datas...", (Object)localSocketAddress);
                this.clientSocketReference.set(clientSocket);
                this.progressCallback.onFFmpegConnection(localport);
                InputStream is = clientSocket.getInputStream();
                byte[] buffer = new byte[1024];
                while ((size = is.read(buffer, 0, buffer.length)) > 0) {
                    List<String> rawBlockLines = new String(buffer, 0, size).lines().map(String::trim).toList();
                    log.trace("ffmpeg progress ({}) send block: {}", (Object)localSocketAddress, rawBlockLines);
                    long beforeProgressDate = System.currentTimeMillis();
                    this.progressCallback.onProgress(localport, new ProgressBlock(rawBlockLines));
                    long afterProgressDate = System.currentTimeMillis();
                    if (afterProgressDate - beforeProgressDate > this.statsPeriod.toMillis()) {
                        log.warn("The time to process the progressCallback ({} sec) take too more time than the ffmpeg's stats_period time ({} sec)", (Object)((afterProgressDate - beforeProgressDate) / 1000L), (Object)this.statsPeriod.toSeconds());
                    }
                    if (rawBlockLines.isEmpty() || !rawBlockLines.get(rawBlockLines.size() - 1).equals("progress=end")) continue;
                    log.debug("Client (ffmpeg?) has now ends it's works on {}", (Object)localSocketAddress);
                    break;
                }
            }
        }
        catch (SocketException e) {
            if ("Connection reset".equalsIgnoreCase(e.getMessage())) {
                this.progressCallback.onConnectionReset(localport, e);
            } else {
                log.error("Socket error", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error("Can't listen socket", (Throwable)e);
        }
        if (localport > 0) {
            this.progressCallback.onEndProgress(localport);
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        return new ServerSocket(0, 1, InetAddress.getByName(LOCALHOST_IPV4));
    }

    public void manualClose() {
        if (!this.currentThread.isAlive()) {
            return;
        }
        log.debug("Manually close socket session...");
        try {
            this.serverSocketReference.get(1L, TimeUnit.SECONDS, ServerSocket::close);
            this.clientSocketReference.get(1L, TimeUnit.SECONDS, Socket::close);
        }
        catch (IOException e) {
            log.error("Can't close socket session", (Throwable)e);
        }
    }
}

