/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeAudioFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeAudioFrameConst;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobePacket;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobePictType;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeVideoFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeVideoFrameConst;
import tv.hd3g.fflauncher.recipes.ContainerAnalyserSession;
import tv.hd3g.fflauncher.recipes.GOPStatItem;

public record ContainerAnalyserResult(ContainerAnalyserSession session, List<FFprobePacket> packets, List<FFprobeAudioFrame> audioFrames, List<FFprobeVideoFrame> videoFrames, FFprobeVideoFrameConst videoConst, FFprobeAudioFrameConst audioConst, List<FFprobeVideoFrameConst> olderVideoConsts, List<FFprobeAudioFrameConst> olderAudioConsts) {
    private static <T> boolean isNotNullAndNotEmpty(List<T> list) {
        return Optional.ofNullable(list).map(l -> !l.isEmpty()).orElse(false);
    }

    public boolean isEmpty() {
        return !ContainerAnalyserResult.isNotNullAndNotEmpty(this.packets) && !ContainerAnalyserResult.isNotNullAndNotEmpty(this.audioFrames) && !ContainerAnalyserResult.isNotNullAndNotEmpty(this.videoFrames) && this.videoConst == null && this.audioConst == null && !ContainerAnalyserResult.isNotNullAndNotEmpty(this.olderVideoConsts) && !ContainerAnalyserResult.isNotNullAndNotEmpty(this.olderAudioConsts);
    }

    public List<GOPStatItem> extractGOPStats() {
        if (this.videoFrames == null || this.videoFrames.isEmpty() || this.videoFrames.stream().allMatch(f -> FFprobePictType.I.equals((Object)f.pictType()) || FFprobePictType.UNKNOWN.equals((Object)f.pictType()))) {
            return List.of();
        }
        return this.videoFrames.stream().reduce(new ArrayList(), (list, f) -> {
            if (FFprobePictType.I.equals((Object)f.pictType()) || list.isEmpty()) {
                list.add(new ArrayList<FFprobeVideoFrame>(List.of(f)));
            } else {
                ((List)list.get(list.size() - 1)).add(f);
            }
            return list;
        }, (l, r) -> {
            l.addAll(r);
            return l;
        }).stream().map(list -> {
            int gopFrameCount = list.size();
            long gopDataSize = list.stream().mapToLong(f -> f.frame().pktSize()).sum();
            int bFramesCount = (int)list.stream().filter(f -> FFprobePictType.B.equals((Object)f.pictType())).count();
            int iFrameDataSize = ((FFprobeVideoFrame)list.get(0)).frame().pktSize();
            long bFramesDataSize = list.stream().filter(f -> FFprobePictType.B.equals((Object)f.pictType())).mapToLong(f -> f.frame().pktSize()).sum();
            return new GOPStatItem(gopFrameCount, gopDataSize, bFramesCount, iFrameDataSize, bFramesDataSize, Collections.unmodifiableList(list));
        }).toList();
    }
}

