/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import tv.hd3g.fflauncher.FFmpeg;
import tv.hd3g.fflauncher.about.FFAbout;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;
import tv.hd3g.fflauncher.progress.ProgressCallback;
import tv.hd3g.fflauncher.progress.ProgressListener;
import tv.hd3g.fflauncher.recipes.AddFiltersTraits;
import tv.hd3g.fflauncher.recipes.MediaAnalyserSession;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class MediaAnalyser
implements AddFiltersTraits {
    private final String execName;
    private final ExecutableFinder executableFinder;
    private final FFAbout about;
    private final List<AudioFilterSupplier> audioFilters;
    private final List<VideoFilterSupplier> videoFilters;
    private ProgressListener progressListener;
    private ProgressCallback progressCallback;

    public MediaAnalyser(String execName, ExecutableFinder executableFinder, FFAbout about) {
        this.execName = Objects.requireNonNull(execName);
        this.executableFinder = Objects.requireNonNull(executableFinder);
        this.about = Objects.requireNonNull(about, "\"about\" can't to be null");
        this.audioFilters = Collections.synchronizedList(new ArrayList());
        this.videoFilters = Collections.synchronizedList(new ArrayList());
    }

    public MediaAnalyserSession createSession(File source) {
        return new MediaAnalyserSession(this, null, source);
    }

    public MediaAnalyserSession createSession(String source) {
        return new MediaAnalyserSession(this, source, null);
    }

    public ExecutableFinder getExecutableFinder() {
        return this.executableFinder;
    }

    List<AudioFilterSupplier> getAudioFilters() {
        return this.audioFilters;
    }

    List<VideoFilterSupplier> getVideoFilters() {
        return this.videoFilters;
    }

    public void setProgress(ProgressListener progressListener, ProgressCallback progressCallback) {
        this.progressListener = progressListener;
        this.progressCallback = progressCallback;
        if (progressListener == null ^ progressCallback == null) {
            throw new IllegalArgumentException("You must set or reset both listener and callback");
        }
    }

    @Override
    public boolean addFilter(VideoFilterSupplier vf) {
        if (this.about.isFilterIsAvaliable(vf.toFilter().getFilterName())) {
            this.videoFilters.add(vf);
            return true;
        }
        return false;
    }

    @Override
    public boolean addFilter(AudioFilterSupplier af) {
        if (this.about.isFilterIsAvaliable(af.toFilter().getFilterName())) {
            this.audioFilters.add(af);
            return true;
        }
        return false;
    }

    public FFmpeg createFFmpeg() {
        FFmpeg ffmpeg = new FFmpeg(this.execName, new Parameters());
        if (this.progressListener != null) {
            ffmpeg.setProgressListener(this.progressListener, this.progressCallback);
        }
        return ffmpeg;
    }

    public static String assertAndParse(String item, String assertStarts) {
        return MediaAnalyser.assertAndParse(item, assertStarts, l -> l);
    }

    public static <T> T assertAndParse(String item, String assertStarts, Function<String, T> parser) {
        if (!item.startsWith(assertStarts)) {
            throw new IllegalArgumentException("Not a " + assertStarts + ": " + item);
        }
        return parser.apply(item.substring(assertStarts.length()));
    }

    public static List<String> splitter(String line, char with) {
        return MediaAnalyser.splitter(line, with, Integer.MAX_VALUE);
    }

    public static List<String> splitter(String line, char with, int max) {
        StringBuilder currentChars = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        for (int pos = 0; pos < line.length(); ++pos) {
            char chr = line.charAt(pos);
            if (chr != with) {
                currentChars.append(chr);
                continue;
            }
            if (currentChars.isEmpty()) continue;
            result.add(currentChars.toString());
            currentChars = new StringBuilder();
            if (result.size() < max) continue;
            return Collections.unmodifiableList(result);
        }
        if (!currentChars.isEmpty()) {
            result.add(currentChars.toString());
        }
        return Collections.unmodifiableList(result);
    }
}

