@file:Suppress("unused", "FunctionName")
package math

import math.internal.MutableXYZImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmOverloads
@JvmName("MutableXYZOfShort")
inline fun MutableXYZ(
	x: Short = 0,
	y: Short = 0,
	z: Short = 0,
): MutableXYZ<Short> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("MutableXYZOfByte")
inline fun MutableXYZ(
	x: Byte = 0,
	y: Byte = 0,
	z: Byte = 0,
): MutableXYZ<Byte> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("MutableXYZOfInt")
inline fun MutableXYZ(
	x: Int = 0,
	y: Int = 0,
	z: Int = 0,
): MutableXYZ<Int> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("MutableXYZOfLong")
inline fun MutableXYZ(
	x: Long = 0L,
	y: Long = 0L,
	z: Long = 0L,
): MutableXYZ<Long> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("MutableXYZOfFloat")
inline fun MutableXYZ(
	x: Float = 0f,
	y: Float = 0f,
	z: Float = 0f,
): MutableXYZ<Float> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("MutableXYZOfDouble")
inline fun MutableXYZ(
	x: Double = 0.0,
	y: Double = 0.0,
	z: Double = 0.0,
): MutableXYZ<Double> = MutableXYZImpl(x, y, z)

@JvmName("MutableXYZOf")
inline fun <N> MutableXYZ(x: N,y: N,z: N,): MutableXYZ<N> = MutableXYZImpl(x, y, z)