@file:Suppress("unused", "FunctionName")
package math

import math.internal.MutableXYImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmOverloads
@JvmName("XYOfShort")
inline fun XY(
	x: Short = 0,
	y: Short = 0,
): XY<Short> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("XYOfByte")
inline fun XY(
	x: Byte = 0,
	y: Byte = 0,
): XY<Byte> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("XYOfInt")
inline fun XY(
	x: Int = 0,
	y: Int = 0,
): XY<Int> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("XYOfLong")
inline fun XY(
	x: Long = 0L,
	y: Long = 0L,
): XY<Long> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("XYOfFloat")
inline fun XY(
	x: Float = 0f,
	y: Float = 0f,
): XY<Float> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("XYOfDouble")
inline fun XY(
	x: Double = 0.0,
	y: Double = 0.0,
): XY<Double> = MutableXYImpl(x, y)

@JvmName("XYOf")
inline fun <N> XY(x: N,y: N,): XY<N> = MutableXYImpl(x, y)