@file:Suppress("unused", "FunctionName")
package math

import math.internal.MutableXYZImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmOverloads
@JvmName("XYZOfShort")
inline fun XYZ(
	x: Short = 0,
	y: Short = 0,
	z: Short = 0,
): XYZ<Short> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("XYZOfByte")
inline fun XYZ(
	x: Byte = 0,
	y: Byte = 0,
	z: Byte = 0,
): XYZ<Byte> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("XYZOfInt")
inline fun XYZ(
	x: Int = 0,
	y: Int = 0,
	z: Int = 0,
): XYZ<Int> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("XYZOfLong")
inline fun XYZ(
	x: Long = 0L,
	y: Long = 0L,
	z: Long = 0L,
): XYZ<Long> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("XYZOfFloat")
inline fun XYZ(
	x: Float = 0f,
	y: Float = 0f,
	z: Float = 0f,
): XYZ<Float> = MutableXYZImpl(x, y, z)

@JvmOverloads
@JvmName("XYZOfDouble")
inline fun XYZ(
	x: Double = 0.0,
	y: Double = 0.0,
	z: Double = 0.0,
): XYZ<Double> = MutableXYZImpl(x, y, z)

@JvmName("XYZOf")
inline fun <N> XYZ(x: N,y: N,z: N,): XYZ<N> = MutableXYZImpl(x, y, z)