@file:Suppress("unused", "FunctionName")
package math.spatial

import math.*
import kotlin.jvm.JvmName

@JvmName("MutableXYZIntDivXYShort")
inline operator fun MutableXYZ<Int>.divAssign(other: XY<Short>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZIntDivXYShort")
inline operator fun MutableXYZ<Int>.divAssign(other: XYZ<Short>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZIntDivShort")
inline operator fun MutableXYZ<Int>.divAssign(other: Short) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZIntDivXYByte")
inline operator fun MutableXYZ<Int>.divAssign(other: XY<Byte>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZIntDivXYByte")
inline operator fun MutableXYZ<Int>.divAssign(other: XYZ<Byte>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZIntDivByte")
inline operator fun MutableXYZ<Int>.divAssign(other: Byte) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZIntDivXYInt")
inline operator fun MutableXYZ<Int>.divAssign(other: XY<Int>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZIntDivXYInt")
inline operator fun MutableXYZ<Int>.divAssign(other: XYZ<Int>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZIntDivInt")
inline operator fun MutableXYZ<Int>.divAssign(other: Int) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZLongDivXYShort")
inline operator fun MutableXYZ<Long>.divAssign(other: XY<Short>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZLongDivXYShort")
inline operator fun MutableXYZ<Long>.divAssign(other: XYZ<Short>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZLongDivShort")
inline operator fun MutableXYZ<Long>.divAssign(other: Short) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZLongDivXYByte")
inline operator fun MutableXYZ<Long>.divAssign(other: XY<Byte>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZLongDivXYByte")
inline operator fun MutableXYZ<Long>.divAssign(other: XYZ<Byte>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZLongDivByte")
inline operator fun MutableXYZ<Long>.divAssign(other: Byte) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZLongDivXYInt")
inline operator fun MutableXYZ<Long>.divAssign(other: XY<Int>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZLongDivXYInt")
inline operator fun MutableXYZ<Long>.divAssign(other: XYZ<Int>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZLongDivInt")
inline operator fun MutableXYZ<Long>.divAssign(other: Int) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZLongDivXYLong")
inline operator fun MutableXYZ<Long>.divAssign(other: XY<Long>) {
	x /= other.x
	y /= other.y
	z /= 0L
}

@JvmName("MutableXYZLongDivXYLong")
inline operator fun MutableXYZ<Long>.divAssign(other: XYZ<Long>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZLongDivLong")
inline operator fun MutableXYZ<Long>.divAssign(other: Long) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZFloatDivXYShort")
inline operator fun MutableXYZ<Float>.divAssign(other: XY<Short>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZFloatDivXYShort")
inline operator fun MutableXYZ<Float>.divAssign(other: XYZ<Short>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZFloatDivShort")
inline operator fun MutableXYZ<Float>.divAssign(other: Short) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZFloatDivXYByte")
inline operator fun MutableXYZ<Float>.divAssign(other: XY<Byte>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZFloatDivXYByte")
inline operator fun MutableXYZ<Float>.divAssign(other: XYZ<Byte>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZFloatDivByte")
inline operator fun MutableXYZ<Float>.divAssign(other: Byte) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZFloatDivXYInt")
inline operator fun MutableXYZ<Float>.divAssign(other: XY<Int>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZFloatDivXYInt")
inline operator fun MutableXYZ<Float>.divAssign(other: XYZ<Int>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZFloatDivInt")
inline operator fun MutableXYZ<Float>.divAssign(other: Int) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZFloatDivXYLong")
inline operator fun MutableXYZ<Float>.divAssign(other: XY<Long>) {
	x /= other.x
	y /= other.y
	z /= 0L
}

@JvmName("MutableXYZFloatDivXYLong")
inline operator fun MutableXYZ<Float>.divAssign(other: XYZ<Long>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZFloatDivLong")
inline operator fun MutableXYZ<Float>.divAssign(other: Long) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZFloatDivXYFloat")
inline operator fun MutableXYZ<Float>.divAssign(other: XY<Float>) {
	x /= other.x
	y /= other.y
	z /= 0f
}

@JvmName("MutableXYZFloatDivXYFloat")
inline operator fun MutableXYZ<Float>.divAssign(other: XYZ<Float>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZFloatDivFloat")
inline operator fun MutableXYZ<Float>.divAssign(other: Float) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZDoubleDivXYShort")
inline operator fun MutableXYZ<Double>.divAssign(other: XY<Short>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZDoubleDivXYShort")
inline operator fun MutableXYZ<Double>.divAssign(other: XYZ<Short>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZDoubleDivShort")
inline operator fun MutableXYZ<Double>.divAssign(other: Short) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZDoubleDivXYByte")
inline operator fun MutableXYZ<Double>.divAssign(other: XY<Byte>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZDoubleDivXYByte")
inline operator fun MutableXYZ<Double>.divAssign(other: XYZ<Byte>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZDoubleDivByte")
inline operator fun MutableXYZ<Double>.divAssign(other: Byte) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZDoubleDivXYInt")
inline operator fun MutableXYZ<Double>.divAssign(other: XY<Int>) {
	x /= other.x
	y /= other.y
	z /= 0
}

@JvmName("MutableXYZDoubleDivXYInt")
inline operator fun MutableXYZ<Double>.divAssign(other: XYZ<Int>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZDoubleDivInt")
inline operator fun MutableXYZ<Double>.divAssign(other: Int) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZDoubleDivXYLong")
inline operator fun MutableXYZ<Double>.divAssign(other: XY<Long>) {
	x /= other.x
	y /= other.y
	z /= 0L
}

@JvmName("MutableXYZDoubleDivXYLong")
inline operator fun MutableXYZ<Double>.divAssign(other: XYZ<Long>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZDoubleDivLong")
inline operator fun MutableXYZ<Double>.divAssign(other: Long) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZDoubleDivXYFloat")
inline operator fun MutableXYZ<Double>.divAssign(other: XY<Float>) {
	x /= other.x
	y /= other.y
	z /= 0f
}

@JvmName("MutableXYZDoubleDivXYFloat")
inline operator fun MutableXYZ<Double>.divAssign(other: XYZ<Float>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZDoubleDivFloat")
inline operator fun MutableXYZ<Double>.divAssign(other: Float) {
	x /= other
	y /= other
	z /= other
}

@JvmName("MutableXYZDoubleDivXYDouble")
inline operator fun MutableXYZ<Double>.divAssign(other: XY<Double>) {
	x /= other.x
	y /= other.y
	z /= 0.0
}

@JvmName("MutableXYZDoubleDivXYDouble")
inline operator fun MutableXYZ<Double>.divAssign(other: XYZ<Double>) {
	x /= other.x
	y /= other.y
	z /= other.y
}

@JvmName("MutableXYZDoubleDivDouble")
inline operator fun MutableXYZ<Double>.divAssign(other: Double) {
	x /= other
	y /= other
	z /= other
}

