@file:Suppress("unused", "FunctionName")
package math.spatial

import math.XY
import math.XYZ
import math.internal.MutableXYZImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmName("convertFromXYShortToXYZShort")
inline fun XY<Short>.toXYZ(x: Short = this.x, y: Short = this.y, z: Short = 0) : XYZ<Short> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYByteToXYZByte")
inline fun XY<Byte>.toXYZ(x: Byte = this.x, y: Byte = this.y, z: Byte = 0) : XYZ<Byte> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYIntToXYZInt")
inline fun XY<Int>.toXYZ(x: Int = this.x, y: Int = this.y, z: Int = 0) : XYZ<Int> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYLongToXYZLong")
inline fun XY<Long>.toXYZ(x: Long = this.x, y: Long = this.y, z: Long = 0L) : XYZ<Long> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYFloatToXYZFloat")
inline fun XY<Float>.toXYZ(x: Float = this.x, y: Float = this.y, z: Float = 0f) : XYZ<Float> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYDoubleToXYZDouble")
inline fun XY<Double>.toXYZ(x: Double = this.x, y: Double = this.y, z: Double = 0.0) : XYZ<Double> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYToXYZ")
inline fun <N> XY<N>.toXYZ(x: N = this.x, y: N = this.y, z: N) : XYZ<N> = MutableXYZImpl(x,y,z)