@file:Suppress("unused", "FunctionName")
package math.spatial

import math.XYZ
import math.sqrt
import kotlin.jvm.JvmName


@JvmName("ShortXYZSquareDistanceToShortXYZ")
inline fun XYZ<Short>.squareDistanceTo(point: XYZ<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ShortXYZDistanceToShortXYZ")
inline fun XYZ<Short>.distanceTo(point: XYZ<Short>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYZSquareDistanceToByteXYZ")
inline fun XYZ<Short>.squareDistanceTo(point: XYZ<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ShortXYZDistanceToByteXYZ")
inline fun XYZ<Short>.distanceTo(point: XYZ<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYZSquareDistanceToIntXYZ")
inline fun XYZ<Short>.squareDistanceTo(point: XYZ<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ShortXYZDistanceToIntXYZ")
inline fun XYZ<Short>.distanceTo(point: XYZ<Int>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYZSquareDistanceToLongXYZ")
inline fun XYZ<Short>.squareDistanceTo(point: XYZ<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ShortXYZDistanceToLongXYZ")
inline fun XYZ<Short>.distanceTo(point: XYZ<Long>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYZSquareDistanceToFloatXYZ")
inline fun XYZ<Short>.squareDistanceTo(point: XYZ<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ShortXYZDistanceToFloatXYZ")
inline fun XYZ<Short>.distanceTo(point: XYZ<Float>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYZSquareDistanceToDoubleXYZ")
inline fun XYZ<Short>.squareDistanceTo(point: XYZ<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ShortXYZDistanceToDoubleXYZ")
inline fun XYZ<Short>.distanceTo(point: XYZ<Double>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYZSquareDistanceToShortXYZ")
inline fun XYZ<Byte>.squareDistanceTo(point: XYZ<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ByteXYZDistanceToShortXYZ")
inline fun XYZ<Byte>.distanceTo(point: XYZ<Short>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYZSquareDistanceToByteXYZ")
inline fun XYZ<Byte>.squareDistanceTo(point: XYZ<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ByteXYZDistanceToByteXYZ")
inline fun XYZ<Byte>.distanceTo(point: XYZ<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYZSquareDistanceToIntXYZ")
inline fun XYZ<Byte>.squareDistanceTo(point: XYZ<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ByteXYZDistanceToIntXYZ")
inline fun XYZ<Byte>.distanceTo(point: XYZ<Int>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYZSquareDistanceToLongXYZ")
inline fun XYZ<Byte>.squareDistanceTo(point: XYZ<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ByteXYZDistanceToLongXYZ")
inline fun XYZ<Byte>.distanceTo(point: XYZ<Long>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYZSquareDistanceToFloatXYZ")
inline fun XYZ<Byte>.squareDistanceTo(point: XYZ<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ByteXYZDistanceToFloatXYZ")
inline fun XYZ<Byte>.distanceTo(point: XYZ<Float>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYZSquareDistanceToDoubleXYZ")
inline fun XYZ<Byte>.squareDistanceTo(point: XYZ<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("ByteXYZDistanceToDoubleXYZ")
inline fun XYZ<Byte>.distanceTo(point: XYZ<Double>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYZSquareDistanceToShortXYZ")
inline fun XYZ<Int>.squareDistanceTo(point: XYZ<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("IntXYZDistanceToShortXYZ")
inline fun XYZ<Int>.distanceTo(point: XYZ<Short>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYZSquareDistanceToByteXYZ")
inline fun XYZ<Int>.squareDistanceTo(point: XYZ<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("IntXYZDistanceToByteXYZ")
inline fun XYZ<Int>.distanceTo(point: XYZ<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYZSquareDistanceToIntXYZ")
inline fun XYZ<Int>.squareDistanceTo(point: XYZ<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("IntXYZDistanceToIntXYZ")
inline fun XYZ<Int>.distanceTo(point: XYZ<Int>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYZSquareDistanceToLongXYZ")
inline fun XYZ<Int>.squareDistanceTo(point: XYZ<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("IntXYZDistanceToLongXYZ")
inline fun XYZ<Int>.distanceTo(point: XYZ<Long>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYZSquareDistanceToFloatXYZ")
inline fun XYZ<Int>.squareDistanceTo(point: XYZ<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("IntXYZDistanceToFloatXYZ")
inline fun XYZ<Int>.distanceTo(point: XYZ<Float>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYZSquareDistanceToDoubleXYZ")
inline fun XYZ<Int>.squareDistanceTo(point: XYZ<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("IntXYZDistanceToDoubleXYZ")
inline fun XYZ<Int>.distanceTo(point: XYZ<Double>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYZSquareDistanceToShortXYZ")
inline fun XYZ<Long>.squareDistanceTo(point: XYZ<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("LongXYZDistanceToShortXYZ")
inline fun XYZ<Long>.distanceTo(point: XYZ<Short>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYZSquareDistanceToByteXYZ")
inline fun XYZ<Long>.squareDistanceTo(point: XYZ<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("LongXYZDistanceToByteXYZ")
inline fun XYZ<Long>.distanceTo(point: XYZ<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYZSquareDistanceToIntXYZ")
inline fun XYZ<Long>.squareDistanceTo(point: XYZ<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("LongXYZDistanceToIntXYZ")
inline fun XYZ<Long>.distanceTo(point: XYZ<Int>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYZSquareDistanceToLongXYZ")
inline fun XYZ<Long>.squareDistanceTo(point: XYZ<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("LongXYZDistanceToLongXYZ")
inline fun XYZ<Long>.distanceTo(point: XYZ<Long>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYZSquareDistanceToFloatXYZ")
inline fun XYZ<Long>.squareDistanceTo(point: XYZ<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("LongXYZDistanceToFloatXYZ")
inline fun XYZ<Long>.distanceTo(point: XYZ<Float>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYZSquareDistanceToDoubleXYZ")
inline fun XYZ<Long>.squareDistanceTo(point: XYZ<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("LongXYZDistanceToDoubleXYZ")
inline fun XYZ<Long>.distanceTo(point: XYZ<Double>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYZSquareDistanceToShortXYZ")
inline fun XYZ<Float>.squareDistanceTo(point: XYZ<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("FloatXYZDistanceToShortXYZ")
inline fun XYZ<Float>.distanceTo(point: XYZ<Short>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYZSquareDistanceToByteXYZ")
inline fun XYZ<Float>.squareDistanceTo(point: XYZ<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("FloatXYZDistanceToByteXYZ")
inline fun XYZ<Float>.distanceTo(point: XYZ<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYZSquareDistanceToIntXYZ")
inline fun XYZ<Float>.squareDistanceTo(point: XYZ<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("FloatXYZDistanceToIntXYZ")
inline fun XYZ<Float>.distanceTo(point: XYZ<Int>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYZSquareDistanceToLongXYZ")
inline fun XYZ<Float>.squareDistanceTo(point: XYZ<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("FloatXYZDistanceToLongXYZ")
inline fun XYZ<Float>.distanceTo(point: XYZ<Long>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYZSquareDistanceToFloatXYZ")
inline fun XYZ<Float>.squareDistanceTo(point: XYZ<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("FloatXYZDistanceToFloatXYZ")
inline fun XYZ<Float>.distanceTo(point: XYZ<Float>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYZSquareDistanceToDoubleXYZ")
inline fun XYZ<Float>.squareDistanceTo(point: XYZ<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("FloatXYZDistanceToDoubleXYZ")
inline fun XYZ<Float>.distanceTo(point: XYZ<Double>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYZSquareDistanceToShortXYZ")
inline fun XYZ<Double>.squareDistanceTo(point: XYZ<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("DoubleXYZDistanceToShortXYZ")
inline fun XYZ<Double>.distanceTo(point: XYZ<Short>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYZSquareDistanceToByteXYZ")
inline fun XYZ<Double>.squareDistanceTo(point: XYZ<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("DoubleXYZDistanceToByteXYZ")
inline fun XYZ<Double>.distanceTo(point: XYZ<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYZSquareDistanceToIntXYZ")
inline fun XYZ<Double>.squareDistanceTo(point: XYZ<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("DoubleXYZDistanceToIntXYZ")
inline fun XYZ<Double>.distanceTo(point: XYZ<Int>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYZSquareDistanceToLongXYZ")
inline fun XYZ<Double>.squareDistanceTo(point: XYZ<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("DoubleXYZDistanceToLongXYZ")
inline fun XYZ<Double>.distanceTo(point: XYZ<Long>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYZSquareDistanceToFloatXYZ")
inline fun XYZ<Double>.squareDistanceTo(point: XYZ<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("DoubleXYZDistanceToFloatXYZ")
inline fun XYZ<Double>.distanceTo(point: XYZ<Float>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYZSquareDistanceToDoubleXYZ")
inline fun XYZ<Double>.squareDistanceTo(point: XYZ<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) + ((z - point.z) * (z - point.z)) 

@JvmName("DoubleXYZDistanceToDoubleXYZ")
inline fun XYZ<Double>.distanceTo(point: XYZ<Double>) = sqrt(squareDistanceTo(point))

