@file:Suppress("unused", "FunctionName")
package math

import math.internal.MutableXYImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmOverloads
@JvmName("MutableXYOfShort")
inline fun MutableXY(
	x: Short = 0,
	y: Short = 0,
): MutableXY<Short> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("MutableXYOfByte")
inline fun MutableXY(
	x: Byte = 0,
	y: Byte = 0,
): MutableXY<Byte> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("MutableXYOfInt")
inline fun MutableXY(
	x: Int = 0,
	y: Int = 0,
): MutableXY<Int> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("MutableXYOfLong")
inline fun MutableXY(
	x: Long = 0L,
	y: Long = 0L,
): MutableXY<Long> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("MutableXYOfFloat")
inline fun MutableXY(
	x: Float = 0f,
	y: Float = 0f,
): MutableXY<Float> = MutableXYImpl(x, y)

@JvmOverloads
@JvmName("MutableXYOfDouble")
inline fun MutableXY(
	x: Double = 0.0,
	y: Double = 0.0,
): MutableXY<Double> = MutableXYImpl(x, y)

@JvmName("MutableXYOf")
inline fun <N> MutableXY(x: N,y: N,): MutableXY<N> = MutableXYImpl(x, y)