@file:Suppress("unused", "FunctionName")
package math.spatial

import math.MutableXY
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName
import kotlin.js.JsName


@JvmName("MutableXYIntTimesScalarShort")
inline operator fun MutableXY<Int>.times(other: Short) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarShortTimesMutableXYInt")
inline operator fun Short.times(other: MutableXY<Int>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYIntDivScalarShort")
inline operator fun MutableXY<Int>.div(other: Short) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarShortDivMutableXYInt")
inline operator fun Short.div(other: MutableXY<Int>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYIntTimesScalarByte")
inline operator fun MutableXY<Int>.times(other: Byte) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarByteTimesMutableXYInt")
inline operator fun Byte.times(other: MutableXY<Int>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYIntDivScalarByte")
inline operator fun MutableXY<Int>.div(other: Byte) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarByteDivMutableXYInt")
inline operator fun Byte.div(other: MutableXY<Int>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYIntTimesScalarInt")
inline operator fun MutableXY<Int>.times(other: Int) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarIntTimesMutableXYInt")
inline operator fun Int.times(other: MutableXY<Int>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYIntDivScalarInt")
inline operator fun MutableXY<Int>.div(other: Int) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarIntDivMutableXYInt")
inline operator fun Int.div(other: MutableXY<Int>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYLongTimesScalarShort")
inline operator fun MutableXY<Long>.times(other: Short) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarShortTimesMutableXYLong")
inline operator fun Short.times(other: MutableXY<Long>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYLongDivScalarShort")
inline operator fun MutableXY<Long>.div(other: Short) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarShortDivMutableXYLong")
inline operator fun Short.div(other: MutableXY<Long>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYLongTimesScalarByte")
inline operator fun MutableXY<Long>.times(other: Byte) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarByteTimesMutableXYLong")
inline operator fun Byte.times(other: MutableXY<Long>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYLongDivScalarByte")
inline operator fun MutableXY<Long>.div(other: Byte) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarByteDivMutableXYLong")
inline operator fun Byte.div(other: MutableXY<Long>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYLongTimesScalarInt")
inline operator fun MutableXY<Long>.times(other: Int) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarIntTimesMutableXYLong")
inline operator fun Int.times(other: MutableXY<Long>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYLongDivScalarInt")
inline operator fun MutableXY<Long>.div(other: Int) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarIntDivMutableXYLong")
inline operator fun Int.div(other: MutableXY<Long>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYLongTimesScalarLong")
inline operator fun MutableXY<Long>.times(other: Long) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarLongTimesMutableXYLong")
inline operator fun Long.times(other: MutableXY<Long>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYLongDivScalarLong")
inline operator fun MutableXY<Long>.div(other: Long) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarLongDivMutableXYLong")
inline operator fun Long.div(other: MutableXY<Long>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYFloatTimesScalarShort")
inline operator fun MutableXY<Float>.times(other: Short) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarShortTimesMutableXYFloat")
inline operator fun Short.times(other: MutableXY<Float>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYFloatDivScalarShort")
inline operator fun MutableXY<Float>.div(other: Short) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarShortDivMutableXYFloat")
inline operator fun Short.div(other: MutableXY<Float>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYFloatTimesScalarByte")
inline operator fun MutableXY<Float>.times(other: Byte) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarByteTimesMutableXYFloat")
inline operator fun Byte.times(other: MutableXY<Float>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYFloatDivScalarByte")
inline operator fun MutableXY<Float>.div(other: Byte) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarByteDivMutableXYFloat")
inline operator fun Byte.div(other: MutableXY<Float>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYFloatTimesScalarInt")
inline operator fun MutableXY<Float>.times(other: Int) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarIntTimesMutableXYFloat")
inline operator fun Int.times(other: MutableXY<Float>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYFloatDivScalarInt")
inline operator fun MutableXY<Float>.div(other: Int) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarIntDivMutableXYFloat")
inline operator fun Int.div(other: MutableXY<Float>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYFloatTimesScalarLong")
inline operator fun MutableXY<Float>.times(other: Long) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarLongTimesMutableXYFloat")
inline operator fun Long.times(other: MutableXY<Float>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYFloatDivScalarLong")
inline operator fun MutableXY<Float>.div(other: Long) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarLongDivMutableXYFloat")
inline operator fun Long.div(other: MutableXY<Float>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYFloatTimesScalarFloat")
inline operator fun MutableXY<Float>.times(other: Float) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarFloatTimesMutableXYFloat")
inline operator fun Float.times(other: MutableXY<Float>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYFloatDivScalarFloat")
inline operator fun MutableXY<Float>.div(other: Float) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarFloatDivMutableXYFloat")
inline operator fun Float.div(other: MutableXY<Float>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYDoubleTimesScalarShort")
inline operator fun MutableXY<Double>.times(other: Short) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarShortTimesMutableXYDouble")
inline operator fun Short.times(other: MutableXY<Double>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYDoubleDivScalarShort")
inline operator fun MutableXY<Double>.div(other: Short) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarShortDivMutableXYDouble")
inline operator fun Short.div(other: MutableXY<Double>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYDoubleTimesScalarByte")
inline operator fun MutableXY<Double>.times(other: Byte) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarByteTimesMutableXYDouble")
inline operator fun Byte.times(other: MutableXY<Double>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYDoubleDivScalarByte")
inline operator fun MutableXY<Double>.div(other: Byte) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarByteDivMutableXYDouble")
inline operator fun Byte.div(other: MutableXY<Double>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYDoubleTimesScalarInt")
inline operator fun MutableXY<Double>.times(other: Int) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarIntTimesMutableXYDouble")
inline operator fun Int.times(other: MutableXY<Double>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYDoubleDivScalarInt")
inline operator fun MutableXY<Double>.div(other: Int) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarIntDivMutableXYDouble")
inline operator fun Int.div(other: MutableXY<Double>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYDoubleTimesScalarLong")
inline operator fun MutableXY<Double>.times(other: Long) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarLongTimesMutableXYDouble")
inline operator fun Long.times(other: MutableXY<Double>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYDoubleDivScalarLong")
inline operator fun MutableXY<Double>.div(other: Long) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarLongDivMutableXYDouble")
inline operator fun Long.div(other: MutableXY<Double>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYDoubleTimesScalarFloat")
inline operator fun MutableXY<Double>.times(other: Float) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarFloatTimesMutableXYDouble")
inline operator fun Float.times(other: MutableXY<Double>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYDoubleDivScalarFloat")
inline operator fun MutableXY<Double>.div(other: Float) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarFloatDivMutableXYDouble")
inline operator fun Float.div(other: MutableXY<Double>) {
	other.x = this / other.x
	other.y = this / other.y
}

@JvmName("MutableXYDoubleTimesScalarDouble")
inline operator fun MutableXY<Double>.times(other: Double) {
	this.x *= other
	this.y *= other
}

@JvmName("ScalarDoubleTimesMutableXYDouble")
inline operator fun Double.times(other: MutableXY<Double>) {
	other.x = this * other.x
	other.y = this * other.y
}

@JvmName("MutableXYDoubleDivScalarDouble")
inline operator fun MutableXY<Double>.div(other: Double) {
	this.x /= other
	this.y /= other
}

@JvmName("ScalarDoubleDivMutableXYDouble")
inline operator fun Double.div(other: MutableXY<Double>) {
	other.x = this / other.x
	other.y = this / other.y
}

