@file:Suppress("unused", "FunctionName")
package math.spatial

import math.MutableXY
import math.MutableXYZ
import math.internal.MutableXYZImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmName("convertFromMutableXYShortToMutableXYZShort")
inline fun MutableXY<Short>.toMutableXYZ(x: Short = this.x, y: Short = this.y, z: Short = 0) : MutableXYZ<Short> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYByteToMutableXYZByte")
inline fun MutableXY<Byte>.toMutableXYZ(x: Byte = this.x, y: Byte = this.y, z: Byte = 0) : MutableXYZ<Byte> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYIntToMutableXYZInt")
inline fun MutableXY<Int>.toMutableXYZ(x: Int = this.x, y: Int = this.y, z: Int = 0) : MutableXYZ<Int> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYLongToMutableXYZLong")
inline fun MutableXY<Long>.toMutableXYZ(x: Long = this.x, y: Long = this.y, z: Long = 0L) : MutableXYZ<Long> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYFloatToMutableXYZFloat")
inline fun MutableXY<Float>.toMutableXYZ(x: Float = this.x, y: Float = this.y, z: Float = 0f) : MutableXYZ<Float> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYDoubleToMutableXYZDouble")
inline fun MutableXY<Double>.toMutableXYZ(x: Double = this.x, y: Double = this.y, z: Double = 0.0) : MutableXYZ<Double> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYToMutableXYZ")
inline fun <N> MutableXY<N>.toMutableXYZ(x: N = this.x, y: N = this.y, z: N) : MutableXYZ<N> = MutableXYZImpl(x,y,z)