@file:Suppress("unused", "FunctionName")
package math.spatial

import math.MutableXY
import math.XYZ
import math.internal.MutableXYZImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmName("convertFromMutableXYShortToXYZShort")
inline fun MutableXY<Short>.toXYZ(x: Short = this.x, y: Short = this.y, z: Short = 0) : XYZ<Short> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYByteToXYZByte")
inline fun MutableXY<Byte>.toXYZ(x: Byte = this.x, y: Byte = this.y, z: Byte = 0) : XYZ<Byte> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYIntToXYZInt")
inline fun MutableXY<Int>.toXYZ(x: Int = this.x, y: Int = this.y, z: Int = 0) : XYZ<Int> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYLongToXYZLong")
inline fun MutableXY<Long>.toXYZ(x: Long = this.x, y: Long = this.y, z: Long = 0L) : XYZ<Long> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYFloatToXYZFloat")
inline fun MutableXY<Float>.toXYZ(x: Float = this.x, y: Float = this.y, z: Float = 0f) : XYZ<Float> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYDoubleToXYZDouble")
inline fun MutableXY<Double>.toXYZ(x: Double = this.x, y: Double = this.y, z: Double = 0.0) : XYZ<Double> = MutableXYZImpl(x,y,z)

@JvmName("convertFromMutableXYToXYZ")
inline fun <N> MutableXY<N>.toXYZ(x: N = this.x, y: N = this.y, z: N) : XYZ<N> = MutableXYZImpl(x,y,z)