@file:Suppress("unused", "FunctionName")
package math.spatial

import math.*
import kotlin.jvm.JvmName

@JvmName("MutableXYZIntMinusXYShort")
inline operator fun MutableXYZ<Int>.minusAssign(other: XY<Short>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZIntMinusXYShort")
inline operator fun MutableXYZ<Int>.minusAssign(other: XYZ<Short>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZIntMinusShort")
inline operator fun MutableXYZ<Int>.minusAssign(other: Short) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZIntMinusXYByte")
inline operator fun MutableXYZ<Int>.minusAssign(other: XY<Byte>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZIntMinusXYByte")
inline operator fun MutableXYZ<Int>.minusAssign(other: XYZ<Byte>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZIntMinusByte")
inline operator fun MutableXYZ<Int>.minusAssign(other: Byte) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZIntMinusXYInt")
inline operator fun MutableXYZ<Int>.minusAssign(other: XY<Int>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZIntMinusXYInt")
inline operator fun MutableXYZ<Int>.minusAssign(other: XYZ<Int>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZIntMinusInt")
inline operator fun MutableXYZ<Int>.minusAssign(other: Int) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZLongMinusXYShort")
inline operator fun MutableXYZ<Long>.minusAssign(other: XY<Short>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZLongMinusXYShort")
inline operator fun MutableXYZ<Long>.minusAssign(other: XYZ<Short>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZLongMinusShort")
inline operator fun MutableXYZ<Long>.minusAssign(other: Short) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZLongMinusXYByte")
inline operator fun MutableXYZ<Long>.minusAssign(other: XY<Byte>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZLongMinusXYByte")
inline operator fun MutableXYZ<Long>.minusAssign(other: XYZ<Byte>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZLongMinusByte")
inline operator fun MutableXYZ<Long>.minusAssign(other: Byte) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZLongMinusXYInt")
inline operator fun MutableXYZ<Long>.minusAssign(other: XY<Int>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZLongMinusXYInt")
inline operator fun MutableXYZ<Long>.minusAssign(other: XYZ<Int>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZLongMinusInt")
inline operator fun MutableXYZ<Long>.minusAssign(other: Int) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZLongMinusXYLong")
inline operator fun MutableXYZ<Long>.minusAssign(other: XY<Long>) {
	x -= other.x
	y -= other.y
	z -= 0L
}

@JvmName("MutableXYZLongMinusXYLong")
inline operator fun MutableXYZ<Long>.minusAssign(other: XYZ<Long>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZLongMinusLong")
inline operator fun MutableXYZ<Long>.minusAssign(other: Long) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZFloatMinusXYShort")
inline operator fun MutableXYZ<Float>.minusAssign(other: XY<Short>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZFloatMinusXYShort")
inline operator fun MutableXYZ<Float>.minusAssign(other: XYZ<Short>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZFloatMinusShort")
inline operator fun MutableXYZ<Float>.minusAssign(other: Short) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZFloatMinusXYByte")
inline operator fun MutableXYZ<Float>.minusAssign(other: XY<Byte>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZFloatMinusXYByte")
inline operator fun MutableXYZ<Float>.minusAssign(other: XYZ<Byte>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZFloatMinusByte")
inline operator fun MutableXYZ<Float>.minusAssign(other: Byte) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZFloatMinusXYInt")
inline operator fun MutableXYZ<Float>.minusAssign(other: XY<Int>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZFloatMinusXYInt")
inline operator fun MutableXYZ<Float>.minusAssign(other: XYZ<Int>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZFloatMinusInt")
inline operator fun MutableXYZ<Float>.minusAssign(other: Int) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZFloatMinusXYLong")
inline operator fun MutableXYZ<Float>.minusAssign(other: XY<Long>) {
	x -= other.x
	y -= other.y
	z -= 0L
}

@JvmName("MutableXYZFloatMinusXYLong")
inline operator fun MutableXYZ<Float>.minusAssign(other: XYZ<Long>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZFloatMinusLong")
inline operator fun MutableXYZ<Float>.minusAssign(other: Long) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZFloatMinusXYFloat")
inline operator fun MutableXYZ<Float>.minusAssign(other: XY<Float>) {
	x -= other.x
	y -= other.y
	z -= 0f
}

@JvmName("MutableXYZFloatMinusXYFloat")
inline operator fun MutableXYZ<Float>.minusAssign(other: XYZ<Float>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZFloatMinusFloat")
inline operator fun MutableXYZ<Float>.minusAssign(other: Float) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZDoubleMinusXYShort")
inline operator fun MutableXYZ<Double>.minusAssign(other: XY<Short>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZDoubleMinusXYShort")
inline operator fun MutableXYZ<Double>.minusAssign(other: XYZ<Short>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZDoubleMinusShort")
inline operator fun MutableXYZ<Double>.minusAssign(other: Short) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZDoubleMinusXYByte")
inline operator fun MutableXYZ<Double>.minusAssign(other: XY<Byte>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZDoubleMinusXYByte")
inline operator fun MutableXYZ<Double>.minusAssign(other: XYZ<Byte>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZDoubleMinusByte")
inline operator fun MutableXYZ<Double>.minusAssign(other: Byte) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZDoubleMinusXYInt")
inline operator fun MutableXYZ<Double>.minusAssign(other: XY<Int>) {
	x -= other.x
	y -= other.y
	z -= 0
}

@JvmName("MutableXYZDoubleMinusXYInt")
inline operator fun MutableXYZ<Double>.minusAssign(other: XYZ<Int>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZDoubleMinusInt")
inline operator fun MutableXYZ<Double>.minusAssign(other: Int) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZDoubleMinusXYLong")
inline operator fun MutableXYZ<Double>.minusAssign(other: XY<Long>) {
	x -= other.x
	y -= other.y
	z -= 0L
}

@JvmName("MutableXYZDoubleMinusXYLong")
inline operator fun MutableXYZ<Double>.minusAssign(other: XYZ<Long>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZDoubleMinusLong")
inline operator fun MutableXYZ<Double>.minusAssign(other: Long) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZDoubleMinusXYFloat")
inline operator fun MutableXYZ<Double>.minusAssign(other: XY<Float>) {
	x -= other.x
	y -= other.y
	z -= 0f
}

@JvmName("MutableXYZDoubleMinusXYFloat")
inline operator fun MutableXYZ<Double>.minusAssign(other: XYZ<Float>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZDoubleMinusFloat")
inline operator fun MutableXYZ<Double>.minusAssign(other: Float) {
	x -= other
	y -= other
	z -= other
}

@JvmName("MutableXYZDoubleMinusXYDouble")
inline operator fun MutableXYZ<Double>.minusAssign(other: XY<Double>) {
	x -= other.x
	y -= other.y
	z -= 0.0
}

@JvmName("MutableXYZDoubleMinusXYDouble")
inline operator fun MutableXYZ<Double>.minusAssign(other: XYZ<Double>) {
	x -= other.x
	y -= other.y
	z -= other.y
}

@JvmName("MutableXYZDoubleMinusDouble")
inline operator fun MutableXYZ<Double>.minusAssign(other: Double) {
	x -= other
	y -= other
	z -= other
}

