@file:Suppress("unused", "FunctionName")
package math.spatial

import math.*
import kotlin.jvm.JvmName

@JvmName("MutableXYZIntPlusXYShort")
inline operator fun MutableXYZ<Int>.plusAssign(other: XY<Short>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZIntPlusXYShort")
inline operator fun MutableXYZ<Int>.plusAssign(other: XYZ<Short>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZIntPlusShort")
inline operator fun MutableXYZ<Int>.plusAssign(other: Short) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZIntPlusXYByte")
inline operator fun MutableXYZ<Int>.plusAssign(other: XY<Byte>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZIntPlusXYByte")
inline operator fun MutableXYZ<Int>.plusAssign(other: XYZ<Byte>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZIntPlusByte")
inline operator fun MutableXYZ<Int>.plusAssign(other: Byte) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZIntPlusXYInt")
inline operator fun MutableXYZ<Int>.plusAssign(other: XY<Int>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZIntPlusXYInt")
inline operator fun MutableXYZ<Int>.plusAssign(other: XYZ<Int>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZIntPlusInt")
inline operator fun MutableXYZ<Int>.plusAssign(other: Int) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZLongPlusXYShort")
inline operator fun MutableXYZ<Long>.plusAssign(other: XY<Short>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZLongPlusXYShort")
inline operator fun MutableXYZ<Long>.plusAssign(other: XYZ<Short>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZLongPlusShort")
inline operator fun MutableXYZ<Long>.plusAssign(other: Short) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZLongPlusXYByte")
inline operator fun MutableXYZ<Long>.plusAssign(other: XY<Byte>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZLongPlusXYByte")
inline operator fun MutableXYZ<Long>.plusAssign(other: XYZ<Byte>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZLongPlusByte")
inline operator fun MutableXYZ<Long>.plusAssign(other: Byte) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZLongPlusXYInt")
inline operator fun MutableXYZ<Long>.plusAssign(other: XY<Int>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZLongPlusXYInt")
inline operator fun MutableXYZ<Long>.plusAssign(other: XYZ<Int>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZLongPlusInt")
inline operator fun MutableXYZ<Long>.plusAssign(other: Int) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZLongPlusXYLong")
inline operator fun MutableXYZ<Long>.plusAssign(other: XY<Long>) {
	x += other.x
	y += other.y
	z += 0L
}

@JvmName("MutableXYZLongPlusXYLong")
inline operator fun MutableXYZ<Long>.plusAssign(other: XYZ<Long>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZLongPlusLong")
inline operator fun MutableXYZ<Long>.plusAssign(other: Long) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZFloatPlusXYShort")
inline operator fun MutableXYZ<Float>.plusAssign(other: XY<Short>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZFloatPlusXYShort")
inline operator fun MutableXYZ<Float>.plusAssign(other: XYZ<Short>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZFloatPlusShort")
inline operator fun MutableXYZ<Float>.plusAssign(other: Short) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZFloatPlusXYByte")
inline operator fun MutableXYZ<Float>.plusAssign(other: XY<Byte>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZFloatPlusXYByte")
inline operator fun MutableXYZ<Float>.plusAssign(other: XYZ<Byte>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZFloatPlusByte")
inline operator fun MutableXYZ<Float>.plusAssign(other: Byte) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZFloatPlusXYInt")
inline operator fun MutableXYZ<Float>.plusAssign(other: XY<Int>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZFloatPlusXYInt")
inline operator fun MutableXYZ<Float>.plusAssign(other: XYZ<Int>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZFloatPlusInt")
inline operator fun MutableXYZ<Float>.plusAssign(other: Int) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZFloatPlusXYLong")
inline operator fun MutableXYZ<Float>.plusAssign(other: XY<Long>) {
	x += other.x
	y += other.y
	z += 0L
}

@JvmName("MutableXYZFloatPlusXYLong")
inline operator fun MutableXYZ<Float>.plusAssign(other: XYZ<Long>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZFloatPlusLong")
inline operator fun MutableXYZ<Float>.plusAssign(other: Long) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZFloatPlusXYFloat")
inline operator fun MutableXYZ<Float>.plusAssign(other: XY<Float>) {
	x += other.x
	y += other.y
	z += 0f
}

@JvmName("MutableXYZFloatPlusXYFloat")
inline operator fun MutableXYZ<Float>.plusAssign(other: XYZ<Float>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZFloatPlusFloat")
inline operator fun MutableXYZ<Float>.plusAssign(other: Float) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZDoublePlusXYShort")
inline operator fun MutableXYZ<Double>.plusAssign(other: XY<Short>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZDoublePlusXYShort")
inline operator fun MutableXYZ<Double>.plusAssign(other: XYZ<Short>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZDoublePlusShort")
inline operator fun MutableXYZ<Double>.plusAssign(other: Short) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZDoublePlusXYByte")
inline operator fun MutableXYZ<Double>.plusAssign(other: XY<Byte>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZDoublePlusXYByte")
inline operator fun MutableXYZ<Double>.plusAssign(other: XYZ<Byte>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZDoublePlusByte")
inline operator fun MutableXYZ<Double>.plusAssign(other: Byte) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZDoublePlusXYInt")
inline operator fun MutableXYZ<Double>.plusAssign(other: XY<Int>) {
	x += other.x
	y += other.y
	z += 0
}

@JvmName("MutableXYZDoublePlusXYInt")
inline operator fun MutableXYZ<Double>.plusAssign(other: XYZ<Int>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZDoublePlusInt")
inline operator fun MutableXYZ<Double>.plusAssign(other: Int) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZDoublePlusXYLong")
inline operator fun MutableXYZ<Double>.plusAssign(other: XY<Long>) {
	x += other.x
	y += other.y
	z += 0L
}

@JvmName("MutableXYZDoublePlusXYLong")
inline operator fun MutableXYZ<Double>.plusAssign(other: XYZ<Long>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZDoublePlusLong")
inline operator fun MutableXYZ<Double>.plusAssign(other: Long) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZDoublePlusXYFloat")
inline operator fun MutableXYZ<Double>.plusAssign(other: XY<Float>) {
	x += other.x
	y += other.y
	z += 0f
}

@JvmName("MutableXYZDoublePlusXYFloat")
inline operator fun MutableXYZ<Double>.plusAssign(other: XYZ<Float>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZDoublePlusFloat")
inline operator fun MutableXYZ<Double>.plusAssign(other: Float) {
	x += other
	y += other
	z += other
}

@JvmName("MutableXYZDoublePlusXYDouble")
inline operator fun MutableXYZ<Double>.plusAssign(other: XY<Double>) {
	x += other.x
	y += other.y
	z += 0.0
}

@JvmName("MutableXYZDoublePlusXYDouble")
inline operator fun MutableXYZ<Double>.plusAssign(other: XYZ<Double>) {
	x += other.x
	y += other.y
	z += other.y
}

@JvmName("MutableXYZDoublePlusDouble")
inline operator fun MutableXYZ<Double>.plusAssign(other: Double) {
	x += other
	y += other
	z += other
}

