@file:Suppress("unused", "FunctionName")
package math.spatial

import math.MutableXYZ
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName
import kotlin.js.JsName


@JvmName("MutableXYZIntTimesScalarShort")
inline operator fun MutableXYZ<Int>.times(other: Short) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarShortTimesMutableXYZInt")
inline operator fun Short.times(other: MutableXYZ<Int>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZIntDivScalarShort")
inline operator fun MutableXYZ<Int>.div(other: Short) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarShortDivMutableXYZInt")
inline operator fun Short.div(other: MutableXYZ<Int>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZIntTimesScalarByte")
inline operator fun MutableXYZ<Int>.times(other: Byte) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarByteTimesMutableXYZInt")
inline operator fun Byte.times(other: MutableXYZ<Int>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZIntDivScalarByte")
inline operator fun MutableXYZ<Int>.div(other: Byte) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarByteDivMutableXYZInt")
inline operator fun Byte.div(other: MutableXYZ<Int>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZIntTimesScalarInt")
inline operator fun MutableXYZ<Int>.times(other: Int) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarIntTimesMutableXYZInt")
inline operator fun Int.times(other: MutableXYZ<Int>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZIntDivScalarInt")
inline operator fun MutableXYZ<Int>.div(other: Int) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarIntDivMutableXYZInt")
inline operator fun Int.div(other: MutableXYZ<Int>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZLongTimesScalarShort")
inline operator fun MutableXYZ<Long>.times(other: Short) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarShortTimesMutableXYZLong")
inline operator fun Short.times(other: MutableXYZ<Long>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZLongDivScalarShort")
inline operator fun MutableXYZ<Long>.div(other: Short) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarShortDivMutableXYZLong")
inline operator fun Short.div(other: MutableXYZ<Long>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZLongTimesScalarByte")
inline operator fun MutableXYZ<Long>.times(other: Byte) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarByteTimesMutableXYZLong")
inline operator fun Byte.times(other: MutableXYZ<Long>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZLongDivScalarByte")
inline operator fun MutableXYZ<Long>.div(other: Byte) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarByteDivMutableXYZLong")
inline operator fun Byte.div(other: MutableXYZ<Long>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZLongTimesScalarInt")
inline operator fun MutableXYZ<Long>.times(other: Int) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarIntTimesMutableXYZLong")
inline operator fun Int.times(other: MutableXYZ<Long>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZLongDivScalarInt")
inline operator fun MutableXYZ<Long>.div(other: Int) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarIntDivMutableXYZLong")
inline operator fun Int.div(other: MutableXYZ<Long>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZLongTimesScalarLong")
inline operator fun MutableXYZ<Long>.times(other: Long) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarLongTimesMutableXYZLong")
inline operator fun Long.times(other: MutableXYZ<Long>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZLongDivScalarLong")
inline operator fun MutableXYZ<Long>.div(other: Long) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarLongDivMutableXYZLong")
inline operator fun Long.div(other: MutableXYZ<Long>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZFloatTimesScalarShort")
inline operator fun MutableXYZ<Float>.times(other: Short) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarShortTimesMutableXYZFloat")
inline operator fun Short.times(other: MutableXYZ<Float>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZFloatDivScalarShort")
inline operator fun MutableXYZ<Float>.div(other: Short) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarShortDivMutableXYZFloat")
inline operator fun Short.div(other: MutableXYZ<Float>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZFloatTimesScalarByte")
inline operator fun MutableXYZ<Float>.times(other: Byte) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarByteTimesMutableXYZFloat")
inline operator fun Byte.times(other: MutableXYZ<Float>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZFloatDivScalarByte")
inline operator fun MutableXYZ<Float>.div(other: Byte) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarByteDivMutableXYZFloat")
inline operator fun Byte.div(other: MutableXYZ<Float>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZFloatTimesScalarInt")
inline operator fun MutableXYZ<Float>.times(other: Int) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarIntTimesMutableXYZFloat")
inline operator fun Int.times(other: MutableXYZ<Float>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZFloatDivScalarInt")
inline operator fun MutableXYZ<Float>.div(other: Int) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarIntDivMutableXYZFloat")
inline operator fun Int.div(other: MutableXYZ<Float>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZFloatTimesScalarLong")
inline operator fun MutableXYZ<Float>.times(other: Long) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarLongTimesMutableXYZFloat")
inline operator fun Long.times(other: MutableXYZ<Float>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZFloatDivScalarLong")
inline operator fun MutableXYZ<Float>.div(other: Long) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarLongDivMutableXYZFloat")
inline operator fun Long.div(other: MutableXYZ<Float>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZFloatTimesScalarFloat")
inline operator fun MutableXYZ<Float>.times(other: Float) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarFloatTimesMutableXYZFloat")
inline operator fun Float.times(other: MutableXYZ<Float>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZFloatDivScalarFloat")
inline operator fun MutableXYZ<Float>.div(other: Float) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarFloatDivMutableXYZFloat")
inline operator fun Float.div(other: MutableXYZ<Float>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZDoubleTimesScalarShort")
inline operator fun MutableXYZ<Double>.times(other: Short) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarShortTimesMutableXYZDouble")
inline operator fun Short.times(other: MutableXYZ<Double>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZDoubleDivScalarShort")
inline operator fun MutableXYZ<Double>.div(other: Short) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarShortDivMutableXYZDouble")
inline operator fun Short.div(other: MutableXYZ<Double>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZDoubleTimesScalarByte")
inline operator fun MutableXYZ<Double>.times(other: Byte) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarByteTimesMutableXYZDouble")
inline operator fun Byte.times(other: MutableXYZ<Double>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZDoubleDivScalarByte")
inline operator fun MutableXYZ<Double>.div(other: Byte) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarByteDivMutableXYZDouble")
inline operator fun Byte.div(other: MutableXYZ<Double>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZDoubleTimesScalarInt")
inline operator fun MutableXYZ<Double>.times(other: Int) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarIntTimesMutableXYZDouble")
inline operator fun Int.times(other: MutableXYZ<Double>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZDoubleDivScalarInt")
inline operator fun MutableXYZ<Double>.div(other: Int) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarIntDivMutableXYZDouble")
inline operator fun Int.div(other: MutableXYZ<Double>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZDoubleTimesScalarLong")
inline operator fun MutableXYZ<Double>.times(other: Long) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarLongTimesMutableXYZDouble")
inline operator fun Long.times(other: MutableXYZ<Double>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZDoubleDivScalarLong")
inline operator fun MutableXYZ<Double>.div(other: Long) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarLongDivMutableXYZDouble")
inline operator fun Long.div(other: MutableXYZ<Double>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZDoubleTimesScalarFloat")
inline operator fun MutableXYZ<Double>.times(other: Float) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarFloatTimesMutableXYZDouble")
inline operator fun Float.times(other: MutableXYZ<Double>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZDoubleDivScalarFloat")
inline operator fun MutableXYZ<Double>.div(other: Float) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarFloatDivMutableXYZDouble")
inline operator fun Float.div(other: MutableXYZ<Double>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

@JvmName("MutableXYZDoubleTimesScalarDouble")
inline operator fun MutableXYZ<Double>.times(other: Double) {
	this.x *= other
	this.y *= other
	this.z *= other
}

@JvmName("ScalarDoubleTimesMutableXYZDouble")
inline operator fun Double.times(other: MutableXYZ<Double>) {
	other.x = this * other.x
	other.y = this * other.y
	other.z = this * other.z
}

@JvmName("MutableXYZDoubleDivScalarDouble")
inline operator fun MutableXYZ<Double>.div(other: Double) {
	this.x /= other
	this.y /= other
	this.z /= other
}

@JvmName("ScalarDoubleDivMutableXYZDouble")
inline operator fun Double.div(other: MutableXYZ<Double>) {
	other.x = this / other.x
	other.y = this / other.y
	other.z = this / other.z
}

