@file:Suppress("unused", "FunctionName")
package math.spatial

import math.XY
import math.sqrt
import kotlin.jvm.JvmName


@JvmName("ShortXYSquareDistanceToShortXY")
inline fun XY<Short>.squareDistanceTo(point: XY<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ShortXYDistanceToShortXY")
inline fun XY<Short>.distanceTo(point: XY<Short>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYSquareDistanceToByteXY")
inline fun XY<Short>.squareDistanceTo(point: XY<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ShortXYDistanceToByteXY")
inline fun XY<Short>.distanceTo(point: XY<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYSquareDistanceToIntXY")
inline fun XY<Short>.squareDistanceTo(point: XY<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ShortXYDistanceToIntXY")
inline fun XY<Short>.distanceTo(point: XY<Int>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYSquareDistanceToLongXY")
inline fun XY<Short>.squareDistanceTo(point: XY<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ShortXYDistanceToLongXY")
inline fun XY<Short>.distanceTo(point: XY<Long>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYSquareDistanceToFloatXY")
inline fun XY<Short>.squareDistanceTo(point: XY<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ShortXYDistanceToFloatXY")
inline fun XY<Short>.distanceTo(point: XY<Float>) = sqrt(squareDistanceTo(point))

@JvmName("ShortXYSquareDistanceToDoubleXY")
inline fun XY<Short>.squareDistanceTo(point: XY<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ShortXYDistanceToDoubleXY")
inline fun XY<Short>.distanceTo(point: XY<Double>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYSquareDistanceToShortXY")
inline fun XY<Byte>.squareDistanceTo(point: XY<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ByteXYDistanceToShortXY")
inline fun XY<Byte>.distanceTo(point: XY<Short>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYSquareDistanceToByteXY")
inline fun XY<Byte>.squareDistanceTo(point: XY<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ByteXYDistanceToByteXY")
inline fun XY<Byte>.distanceTo(point: XY<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYSquareDistanceToIntXY")
inline fun XY<Byte>.squareDistanceTo(point: XY<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ByteXYDistanceToIntXY")
inline fun XY<Byte>.distanceTo(point: XY<Int>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYSquareDistanceToLongXY")
inline fun XY<Byte>.squareDistanceTo(point: XY<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ByteXYDistanceToLongXY")
inline fun XY<Byte>.distanceTo(point: XY<Long>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYSquareDistanceToFloatXY")
inline fun XY<Byte>.squareDistanceTo(point: XY<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ByteXYDistanceToFloatXY")
inline fun XY<Byte>.distanceTo(point: XY<Float>) = sqrt(squareDistanceTo(point))

@JvmName("ByteXYSquareDistanceToDoubleXY")
inline fun XY<Byte>.squareDistanceTo(point: XY<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("ByteXYDistanceToDoubleXY")
inline fun XY<Byte>.distanceTo(point: XY<Double>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYSquareDistanceToShortXY")
inline fun XY<Int>.squareDistanceTo(point: XY<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("IntXYDistanceToShortXY")
inline fun XY<Int>.distanceTo(point: XY<Short>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYSquareDistanceToByteXY")
inline fun XY<Int>.squareDistanceTo(point: XY<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("IntXYDistanceToByteXY")
inline fun XY<Int>.distanceTo(point: XY<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYSquareDistanceToIntXY")
inline fun XY<Int>.squareDistanceTo(point: XY<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("IntXYDistanceToIntXY")
inline fun XY<Int>.distanceTo(point: XY<Int>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYSquareDistanceToLongXY")
inline fun XY<Int>.squareDistanceTo(point: XY<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("IntXYDistanceToLongXY")
inline fun XY<Int>.distanceTo(point: XY<Long>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYSquareDistanceToFloatXY")
inline fun XY<Int>.squareDistanceTo(point: XY<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("IntXYDistanceToFloatXY")
inline fun XY<Int>.distanceTo(point: XY<Float>) = sqrt(squareDistanceTo(point))

@JvmName("IntXYSquareDistanceToDoubleXY")
inline fun XY<Int>.squareDistanceTo(point: XY<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("IntXYDistanceToDoubleXY")
inline fun XY<Int>.distanceTo(point: XY<Double>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYSquareDistanceToShortXY")
inline fun XY<Long>.squareDistanceTo(point: XY<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("LongXYDistanceToShortXY")
inline fun XY<Long>.distanceTo(point: XY<Short>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYSquareDistanceToByteXY")
inline fun XY<Long>.squareDistanceTo(point: XY<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("LongXYDistanceToByteXY")
inline fun XY<Long>.distanceTo(point: XY<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYSquareDistanceToIntXY")
inline fun XY<Long>.squareDistanceTo(point: XY<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("LongXYDistanceToIntXY")
inline fun XY<Long>.distanceTo(point: XY<Int>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYSquareDistanceToLongXY")
inline fun XY<Long>.squareDistanceTo(point: XY<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("LongXYDistanceToLongXY")
inline fun XY<Long>.distanceTo(point: XY<Long>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYSquareDistanceToFloatXY")
inline fun XY<Long>.squareDistanceTo(point: XY<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("LongXYDistanceToFloatXY")
inline fun XY<Long>.distanceTo(point: XY<Float>) = sqrt(squareDistanceTo(point))

@JvmName("LongXYSquareDistanceToDoubleXY")
inline fun XY<Long>.squareDistanceTo(point: XY<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("LongXYDistanceToDoubleXY")
inline fun XY<Long>.distanceTo(point: XY<Double>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYSquareDistanceToShortXY")
inline fun XY<Float>.squareDistanceTo(point: XY<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("FloatXYDistanceToShortXY")
inline fun XY<Float>.distanceTo(point: XY<Short>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYSquareDistanceToByteXY")
inline fun XY<Float>.squareDistanceTo(point: XY<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("FloatXYDistanceToByteXY")
inline fun XY<Float>.distanceTo(point: XY<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYSquareDistanceToIntXY")
inline fun XY<Float>.squareDistanceTo(point: XY<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("FloatXYDistanceToIntXY")
inline fun XY<Float>.distanceTo(point: XY<Int>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYSquareDistanceToLongXY")
inline fun XY<Float>.squareDistanceTo(point: XY<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("FloatXYDistanceToLongXY")
inline fun XY<Float>.distanceTo(point: XY<Long>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYSquareDistanceToFloatXY")
inline fun XY<Float>.squareDistanceTo(point: XY<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("FloatXYDistanceToFloatXY")
inline fun XY<Float>.distanceTo(point: XY<Float>) = sqrt(squareDistanceTo(point))

@JvmName("FloatXYSquareDistanceToDoubleXY")
inline fun XY<Float>.squareDistanceTo(point: XY<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("FloatXYDistanceToDoubleXY")
inline fun XY<Float>.distanceTo(point: XY<Double>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYSquareDistanceToShortXY")
inline fun XY<Double>.squareDistanceTo(point: XY<Short>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("DoubleXYDistanceToShortXY")
inline fun XY<Double>.distanceTo(point: XY<Short>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYSquareDistanceToByteXY")
inline fun XY<Double>.squareDistanceTo(point: XY<Byte>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("DoubleXYDistanceToByteXY")
inline fun XY<Double>.distanceTo(point: XY<Byte>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYSquareDistanceToIntXY")
inline fun XY<Double>.squareDistanceTo(point: XY<Int>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("DoubleXYDistanceToIntXY")
inline fun XY<Double>.distanceTo(point: XY<Int>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYSquareDistanceToLongXY")
inline fun XY<Double>.squareDistanceTo(point: XY<Long>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("DoubleXYDistanceToLongXY")
inline fun XY<Double>.distanceTo(point: XY<Long>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYSquareDistanceToFloatXY")
inline fun XY<Double>.squareDistanceTo(point: XY<Float>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("DoubleXYDistanceToFloatXY")
inline fun XY<Double>.distanceTo(point: XY<Float>) = sqrt(squareDistanceTo(point))

@JvmName("DoubleXYSquareDistanceToDoubleXY")
inline fun XY<Double>.squareDistanceTo(point: XY<Double>) =  ((x - point.x) * (x - point.x)) + ((y - point.y) * (y - point.y)) 

@JvmName("DoubleXYDistanceToDoubleXY")
inline fun XY<Double>.distanceTo(point: XY<Double>) = sqrt(squareDistanceTo(point))

