@file:Suppress("unused", "FunctionName")
package math.spatial

import math.XY
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName
import kotlin.js.JsName


@JvmName("XYShortTimesScalarShort")
inline operator fun XY<Short>.times(other: Short) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarShortTimesXYShort")
inline operator fun Short.times(other: XY<Short>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYShortDivScalarShort")
inline operator fun XY<Short>.div(other: Short) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarShortDivXYShort")
inline operator fun Short.div(other: XY<Short>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYShortTimesScalarByte")
inline operator fun XY<Short>.times(other: Byte) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarByteTimesXYShort")
inline operator fun Byte.times(other: XY<Short>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYShortDivScalarByte")
inline operator fun XY<Short>.div(other: Byte) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarByteDivXYShort")
inline operator fun Byte.div(other: XY<Short>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYShortTimesScalarInt")
inline operator fun XY<Short>.times(other: Int) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarIntTimesXYShort")
inline operator fun Int.times(other: XY<Short>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYShortDivScalarInt")
inline operator fun XY<Short>.div(other: Int) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarIntDivXYShort")
inline operator fun Int.div(other: XY<Short>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYShortTimesScalarLong")
inline operator fun XY<Short>.times(other: Long) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarLongTimesXYShort")
inline operator fun Long.times(other: XY<Short>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYShortDivScalarLong")
inline operator fun XY<Short>.div(other: Long) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarLongDivXYShort")
inline operator fun Long.div(other: XY<Short>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYShortTimesScalarFloat")
inline operator fun XY<Short>.times(other: Float) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarFloatTimesXYShort")
inline operator fun Float.times(other: XY<Short>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYShortDivScalarFloat")
inline operator fun XY<Short>.div(other: Float) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarFloatDivXYShort")
inline operator fun Float.div(other: XY<Short>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYShortTimesScalarDouble")
inline operator fun XY<Short>.times(other: Double) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarDoubleTimesXYShort")
inline operator fun Double.times(other: XY<Short>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYShortDivScalarDouble")
inline operator fun XY<Short>.div(other: Double) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarDoubleDivXYShort")
inline operator fun Double.div(other: XY<Short>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYByteTimesScalarShort")
inline operator fun XY<Byte>.times(other: Short) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarShortTimesXYByte")
inline operator fun Short.times(other: XY<Byte>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYByteDivScalarShort")
inline operator fun XY<Byte>.div(other: Short) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarShortDivXYByte")
inline operator fun Short.div(other: XY<Byte>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYByteTimesScalarByte")
inline operator fun XY<Byte>.times(other: Byte) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarByteTimesXYByte")
inline operator fun Byte.times(other: XY<Byte>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYByteDivScalarByte")
inline operator fun XY<Byte>.div(other: Byte) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarByteDivXYByte")
inline operator fun Byte.div(other: XY<Byte>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYByteTimesScalarInt")
inline operator fun XY<Byte>.times(other: Int) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarIntTimesXYByte")
inline operator fun Int.times(other: XY<Byte>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYByteDivScalarInt")
inline operator fun XY<Byte>.div(other: Int) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarIntDivXYByte")
inline operator fun Int.div(other: XY<Byte>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYByteTimesScalarLong")
inline operator fun XY<Byte>.times(other: Long) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarLongTimesXYByte")
inline operator fun Long.times(other: XY<Byte>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYByteDivScalarLong")
inline operator fun XY<Byte>.div(other: Long) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarLongDivXYByte")
inline operator fun Long.div(other: XY<Byte>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYByteTimesScalarFloat")
inline operator fun XY<Byte>.times(other: Float) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarFloatTimesXYByte")
inline operator fun Float.times(other: XY<Byte>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYByteDivScalarFloat")
inline operator fun XY<Byte>.div(other: Float) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarFloatDivXYByte")
inline operator fun Float.div(other: XY<Byte>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYByteTimesScalarDouble")
inline operator fun XY<Byte>.times(other: Double) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarDoubleTimesXYByte")
inline operator fun Double.times(other: XY<Byte>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYByteDivScalarDouble")
inline operator fun XY<Byte>.div(other: Double) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarDoubleDivXYByte")
inline operator fun Double.div(other: XY<Byte>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYIntTimesScalarShort")
inline operator fun XY<Int>.times(other: Short) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarShortTimesXYInt")
inline operator fun Short.times(other: XY<Int>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYIntDivScalarShort")
inline operator fun XY<Int>.div(other: Short) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarShortDivXYInt")
inline operator fun Short.div(other: XY<Int>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYIntTimesScalarByte")
inline operator fun XY<Int>.times(other: Byte) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarByteTimesXYInt")
inline operator fun Byte.times(other: XY<Int>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYIntDivScalarByte")
inline operator fun XY<Int>.div(other: Byte) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarByteDivXYInt")
inline operator fun Byte.div(other: XY<Int>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYIntTimesScalarInt")
inline operator fun XY<Int>.times(other: Int) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarIntTimesXYInt")
inline operator fun Int.times(other: XY<Int>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYIntDivScalarInt")
inline operator fun XY<Int>.div(other: Int) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarIntDivXYInt")
inline operator fun Int.div(other: XY<Int>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYIntTimesScalarLong")
inline operator fun XY<Int>.times(other: Long) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarLongTimesXYInt")
inline operator fun Long.times(other: XY<Int>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYIntDivScalarLong")
inline operator fun XY<Int>.div(other: Long) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarLongDivXYInt")
inline operator fun Long.div(other: XY<Int>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYIntTimesScalarFloat")
inline operator fun XY<Int>.times(other: Float) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarFloatTimesXYInt")
inline operator fun Float.times(other: XY<Int>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYIntDivScalarFloat")
inline operator fun XY<Int>.div(other: Float) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarFloatDivXYInt")
inline operator fun Float.div(other: XY<Int>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYIntTimesScalarDouble")
inline operator fun XY<Int>.times(other: Double) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarDoubleTimesXYInt")
inline operator fun Double.times(other: XY<Int>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYIntDivScalarDouble")
inline operator fun XY<Int>.div(other: Double) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarDoubleDivXYInt")
inline operator fun Double.div(other: XY<Int>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYLongTimesScalarShort")
inline operator fun XY<Long>.times(other: Short) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarShortTimesXYLong")
inline operator fun Short.times(other: XY<Long>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYLongDivScalarShort")
inline operator fun XY<Long>.div(other: Short) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarShortDivXYLong")
inline operator fun Short.div(other: XY<Long>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYLongTimesScalarByte")
inline operator fun XY<Long>.times(other: Byte) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarByteTimesXYLong")
inline operator fun Byte.times(other: XY<Long>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYLongDivScalarByte")
inline operator fun XY<Long>.div(other: Byte) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarByteDivXYLong")
inline operator fun Byte.div(other: XY<Long>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYLongTimesScalarInt")
inline operator fun XY<Long>.times(other: Int) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarIntTimesXYLong")
inline operator fun Int.times(other: XY<Long>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYLongDivScalarInt")
inline operator fun XY<Long>.div(other: Int) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarIntDivXYLong")
inline operator fun Int.div(other: XY<Long>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYLongTimesScalarLong")
inline operator fun XY<Long>.times(other: Long) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarLongTimesXYLong")
inline operator fun Long.times(other: XY<Long>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYLongDivScalarLong")
inline operator fun XY<Long>.div(other: Long) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarLongDivXYLong")
inline operator fun Long.div(other: XY<Long>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYLongTimesScalarFloat")
inline operator fun XY<Long>.times(other: Float) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarFloatTimesXYLong")
inline operator fun Float.times(other: XY<Long>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYLongDivScalarFloat")
inline operator fun XY<Long>.div(other: Float) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarFloatDivXYLong")
inline operator fun Float.div(other: XY<Long>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYLongTimesScalarDouble")
inline operator fun XY<Long>.times(other: Double) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarDoubleTimesXYLong")
inline operator fun Double.times(other: XY<Long>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYLongDivScalarDouble")
inline operator fun XY<Long>.div(other: Double) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarDoubleDivXYLong")
inline operator fun Double.div(other: XY<Long>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYFloatTimesScalarShort")
inline operator fun XY<Float>.times(other: Short) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarShortTimesXYFloat")
inline operator fun Short.times(other: XY<Float>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYFloatDivScalarShort")
inline operator fun XY<Float>.div(other: Short) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarShortDivXYFloat")
inline operator fun Short.div(other: XY<Float>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYFloatTimesScalarByte")
inline operator fun XY<Float>.times(other: Byte) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarByteTimesXYFloat")
inline operator fun Byte.times(other: XY<Float>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYFloatDivScalarByte")
inline operator fun XY<Float>.div(other: Byte) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarByteDivXYFloat")
inline operator fun Byte.div(other: XY<Float>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYFloatTimesScalarInt")
inline operator fun XY<Float>.times(other: Int) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarIntTimesXYFloat")
inline operator fun Int.times(other: XY<Float>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYFloatDivScalarInt")
inline operator fun XY<Float>.div(other: Int) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarIntDivXYFloat")
inline operator fun Int.div(other: XY<Float>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYFloatTimesScalarLong")
inline operator fun XY<Float>.times(other: Long) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarLongTimesXYFloat")
inline operator fun Long.times(other: XY<Float>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYFloatDivScalarLong")
inline operator fun XY<Float>.div(other: Long) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarLongDivXYFloat")
inline operator fun Long.div(other: XY<Float>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYFloatTimesScalarFloat")
inline operator fun XY<Float>.times(other: Float) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarFloatTimesXYFloat")
inline operator fun Float.times(other: XY<Float>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYFloatDivScalarFloat")
inline operator fun XY<Float>.div(other: Float) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarFloatDivXYFloat")
inline operator fun Float.div(other: XY<Float>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYFloatTimesScalarDouble")
inline operator fun XY<Float>.times(other: Double) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarDoubleTimesXYFloat")
inline operator fun Double.times(other: XY<Float>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYFloatDivScalarDouble")
inline operator fun XY<Float>.div(other: Double) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarDoubleDivXYFloat")
inline operator fun Double.div(other: XY<Float>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYDoubleTimesScalarShort")
inline operator fun XY<Double>.times(other: Short) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarShortTimesXYDouble")
inline operator fun Short.times(other: XY<Double>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYDoubleDivScalarShort")
inline operator fun XY<Double>.div(other: Short) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarShortDivXYDouble")
inline operator fun Short.div(other: XY<Double>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYDoubleTimesScalarByte")
inline operator fun XY<Double>.times(other: Byte) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarByteTimesXYDouble")
inline operator fun Byte.times(other: XY<Double>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYDoubleDivScalarByte")
inline operator fun XY<Double>.div(other: Byte) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarByteDivXYDouble")
inline operator fun Byte.div(other: XY<Double>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYDoubleTimesScalarInt")
inline operator fun XY<Double>.times(other: Int) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarIntTimesXYDouble")
inline operator fun Int.times(other: XY<Double>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYDoubleDivScalarInt")
inline operator fun XY<Double>.div(other: Int) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarIntDivXYDouble")
inline operator fun Int.div(other: XY<Double>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYDoubleTimesScalarLong")
inline operator fun XY<Double>.times(other: Long) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarLongTimesXYDouble")
inline operator fun Long.times(other: XY<Double>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYDoubleDivScalarLong")
inline operator fun XY<Double>.div(other: Long) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarLongDivXYDouble")
inline operator fun Long.div(other: XY<Double>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYDoubleTimesScalarFloat")
inline operator fun XY<Double>.times(other: Float) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarFloatTimesXYDouble")
inline operator fun Float.times(other: XY<Double>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYDoubleDivScalarFloat")
inline operator fun XY<Double>.div(other: Float) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarFloatDivXYDouble")
inline operator fun Float.div(other: XY<Double>) = XY(
	x = this / other.x,
	y = this / other.y,
)

@JvmName("XYDoubleTimesScalarDouble")
inline operator fun XY<Double>.times(other: Double) = XY(
	x = this.x * other,
	y = this.y * other,
)

@JvmName("ScalarDoubleTimesXYDouble")
inline operator fun Double.times(other: XY<Double>) = XY(
	x = this * other.x,
	y = this * other.y,
)

@JvmName("XYDoubleDivScalarDouble")
inline operator fun XY<Double>.div(other: Double) = XY(
	x = this.x / other,
	y = this.y / other,
)

@JvmName("ScalarDoubleDivXYDouble")
inline operator fun Double.div(other: XY<Double>) = XY(
	x = this / other.x,
	y = this / other.y,
)

