@file:Suppress("unused", "FunctionName")
package math.spatial

import math.XY
import math.MutableXYZ
import math.internal.MutableXYZImpl
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName


@JvmName("convertFromXYShortToMutableXYZShort")
inline fun XY<Short>.toMutableXYZ(x: Short = this.x, y: Short = this.y, z: Short = 0) : MutableXYZ<Short> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYByteToMutableXYZByte")
inline fun XY<Byte>.toMutableXYZ(x: Byte = this.x, y: Byte = this.y, z: Byte = 0) : MutableXYZ<Byte> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYIntToMutableXYZInt")
inline fun XY<Int>.toMutableXYZ(x: Int = this.x, y: Int = this.y, z: Int = 0) : MutableXYZ<Int> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYLongToMutableXYZLong")
inline fun XY<Long>.toMutableXYZ(x: Long = this.x, y: Long = this.y, z: Long = 0L) : MutableXYZ<Long> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYFloatToMutableXYZFloat")
inline fun XY<Float>.toMutableXYZ(x: Float = this.x, y: Float = this.y, z: Float = 0f) : MutableXYZ<Float> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYDoubleToMutableXYZDouble")
inline fun XY<Double>.toMutableXYZ(x: Double = this.x, y: Double = this.y, z: Double = 0.0) : MutableXYZ<Double> = MutableXYZImpl(x,y,z)

@JvmName("convertFromXYToMutableXYZ")
inline fun <N> XY<N>.toMutableXYZ(x: N = this.x, y: N = this.y, z: N) : MutableXYZ<N> = MutableXYZImpl(x,y,z)