@file:Suppress("unused", "FunctionName")
package math.spatial

import math.XYZ
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmName
import kotlin.js.JsName


@JvmName("XYZShortTimesScalarShort")
inline operator fun XYZ<Short>.times(other: Short) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarShortTimesXYZShort")
inline operator fun Short.times(other: XYZ<Short>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZShortDivScalarShort")
inline operator fun XYZ<Short>.div(other: Short) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarShortDivXYZShort")
inline operator fun Short.div(other: XYZ<Short>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZShortTimesScalarByte")
inline operator fun XYZ<Short>.times(other: Byte) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarByteTimesXYZShort")
inline operator fun Byte.times(other: XYZ<Short>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZShortDivScalarByte")
inline operator fun XYZ<Short>.div(other: Byte) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarByteDivXYZShort")
inline operator fun Byte.div(other: XYZ<Short>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZShortTimesScalarInt")
inline operator fun XYZ<Short>.times(other: Int) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarIntTimesXYZShort")
inline operator fun Int.times(other: XYZ<Short>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZShortDivScalarInt")
inline operator fun XYZ<Short>.div(other: Int) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarIntDivXYZShort")
inline operator fun Int.div(other: XYZ<Short>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZShortTimesScalarLong")
inline operator fun XYZ<Short>.times(other: Long) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarLongTimesXYZShort")
inline operator fun Long.times(other: XYZ<Short>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZShortDivScalarLong")
inline operator fun XYZ<Short>.div(other: Long) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarLongDivXYZShort")
inline operator fun Long.div(other: XYZ<Short>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZShortTimesScalarFloat")
inline operator fun XYZ<Short>.times(other: Float) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarFloatTimesXYZShort")
inline operator fun Float.times(other: XYZ<Short>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZShortDivScalarFloat")
inline operator fun XYZ<Short>.div(other: Float) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarFloatDivXYZShort")
inline operator fun Float.div(other: XYZ<Short>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZShortTimesScalarDouble")
inline operator fun XYZ<Short>.times(other: Double) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarDoubleTimesXYZShort")
inline operator fun Double.times(other: XYZ<Short>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZShortDivScalarDouble")
inline operator fun XYZ<Short>.div(other: Double) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarDoubleDivXYZShort")
inline operator fun Double.div(other: XYZ<Short>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZByteTimesScalarShort")
inline operator fun XYZ<Byte>.times(other: Short) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarShortTimesXYZByte")
inline operator fun Short.times(other: XYZ<Byte>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZByteDivScalarShort")
inline operator fun XYZ<Byte>.div(other: Short) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarShortDivXYZByte")
inline operator fun Short.div(other: XYZ<Byte>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZByteTimesScalarByte")
inline operator fun XYZ<Byte>.times(other: Byte) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarByteTimesXYZByte")
inline operator fun Byte.times(other: XYZ<Byte>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZByteDivScalarByte")
inline operator fun XYZ<Byte>.div(other: Byte) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarByteDivXYZByte")
inline operator fun Byte.div(other: XYZ<Byte>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZByteTimesScalarInt")
inline operator fun XYZ<Byte>.times(other: Int) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarIntTimesXYZByte")
inline operator fun Int.times(other: XYZ<Byte>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZByteDivScalarInt")
inline operator fun XYZ<Byte>.div(other: Int) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarIntDivXYZByte")
inline operator fun Int.div(other: XYZ<Byte>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZByteTimesScalarLong")
inline operator fun XYZ<Byte>.times(other: Long) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarLongTimesXYZByte")
inline operator fun Long.times(other: XYZ<Byte>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZByteDivScalarLong")
inline operator fun XYZ<Byte>.div(other: Long) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarLongDivXYZByte")
inline operator fun Long.div(other: XYZ<Byte>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZByteTimesScalarFloat")
inline operator fun XYZ<Byte>.times(other: Float) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarFloatTimesXYZByte")
inline operator fun Float.times(other: XYZ<Byte>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZByteDivScalarFloat")
inline operator fun XYZ<Byte>.div(other: Float) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarFloatDivXYZByte")
inline operator fun Float.div(other: XYZ<Byte>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZByteTimesScalarDouble")
inline operator fun XYZ<Byte>.times(other: Double) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarDoubleTimesXYZByte")
inline operator fun Double.times(other: XYZ<Byte>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZByteDivScalarDouble")
inline operator fun XYZ<Byte>.div(other: Double) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarDoubleDivXYZByte")
inline operator fun Double.div(other: XYZ<Byte>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZIntTimesScalarShort")
inline operator fun XYZ<Int>.times(other: Short) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarShortTimesXYZInt")
inline operator fun Short.times(other: XYZ<Int>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZIntDivScalarShort")
inline operator fun XYZ<Int>.div(other: Short) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarShortDivXYZInt")
inline operator fun Short.div(other: XYZ<Int>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZIntTimesScalarByte")
inline operator fun XYZ<Int>.times(other: Byte) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarByteTimesXYZInt")
inline operator fun Byte.times(other: XYZ<Int>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZIntDivScalarByte")
inline operator fun XYZ<Int>.div(other: Byte) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarByteDivXYZInt")
inline operator fun Byte.div(other: XYZ<Int>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZIntTimesScalarInt")
inline operator fun XYZ<Int>.times(other: Int) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarIntTimesXYZInt")
inline operator fun Int.times(other: XYZ<Int>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZIntDivScalarInt")
inline operator fun XYZ<Int>.div(other: Int) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarIntDivXYZInt")
inline operator fun Int.div(other: XYZ<Int>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZIntTimesScalarLong")
inline operator fun XYZ<Int>.times(other: Long) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarLongTimesXYZInt")
inline operator fun Long.times(other: XYZ<Int>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZIntDivScalarLong")
inline operator fun XYZ<Int>.div(other: Long) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarLongDivXYZInt")
inline operator fun Long.div(other: XYZ<Int>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZIntTimesScalarFloat")
inline operator fun XYZ<Int>.times(other: Float) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarFloatTimesXYZInt")
inline operator fun Float.times(other: XYZ<Int>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZIntDivScalarFloat")
inline operator fun XYZ<Int>.div(other: Float) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarFloatDivXYZInt")
inline operator fun Float.div(other: XYZ<Int>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZIntTimesScalarDouble")
inline operator fun XYZ<Int>.times(other: Double) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarDoubleTimesXYZInt")
inline operator fun Double.times(other: XYZ<Int>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZIntDivScalarDouble")
inline operator fun XYZ<Int>.div(other: Double) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarDoubleDivXYZInt")
inline operator fun Double.div(other: XYZ<Int>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZLongTimesScalarShort")
inline operator fun XYZ<Long>.times(other: Short) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarShortTimesXYZLong")
inline operator fun Short.times(other: XYZ<Long>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZLongDivScalarShort")
inline operator fun XYZ<Long>.div(other: Short) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarShortDivXYZLong")
inline operator fun Short.div(other: XYZ<Long>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZLongTimesScalarByte")
inline operator fun XYZ<Long>.times(other: Byte) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarByteTimesXYZLong")
inline operator fun Byte.times(other: XYZ<Long>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZLongDivScalarByte")
inline operator fun XYZ<Long>.div(other: Byte) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarByteDivXYZLong")
inline operator fun Byte.div(other: XYZ<Long>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZLongTimesScalarInt")
inline operator fun XYZ<Long>.times(other: Int) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarIntTimesXYZLong")
inline operator fun Int.times(other: XYZ<Long>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZLongDivScalarInt")
inline operator fun XYZ<Long>.div(other: Int) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarIntDivXYZLong")
inline operator fun Int.div(other: XYZ<Long>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZLongTimesScalarLong")
inline operator fun XYZ<Long>.times(other: Long) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarLongTimesXYZLong")
inline operator fun Long.times(other: XYZ<Long>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZLongDivScalarLong")
inline operator fun XYZ<Long>.div(other: Long) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarLongDivXYZLong")
inline operator fun Long.div(other: XYZ<Long>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZLongTimesScalarFloat")
inline operator fun XYZ<Long>.times(other: Float) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarFloatTimesXYZLong")
inline operator fun Float.times(other: XYZ<Long>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZLongDivScalarFloat")
inline operator fun XYZ<Long>.div(other: Float) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarFloatDivXYZLong")
inline operator fun Float.div(other: XYZ<Long>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZLongTimesScalarDouble")
inline operator fun XYZ<Long>.times(other: Double) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarDoubleTimesXYZLong")
inline operator fun Double.times(other: XYZ<Long>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZLongDivScalarDouble")
inline operator fun XYZ<Long>.div(other: Double) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarDoubleDivXYZLong")
inline operator fun Double.div(other: XYZ<Long>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZFloatTimesScalarShort")
inline operator fun XYZ<Float>.times(other: Short) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarShortTimesXYZFloat")
inline operator fun Short.times(other: XYZ<Float>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZFloatDivScalarShort")
inline operator fun XYZ<Float>.div(other: Short) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarShortDivXYZFloat")
inline operator fun Short.div(other: XYZ<Float>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZFloatTimesScalarByte")
inline operator fun XYZ<Float>.times(other: Byte) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarByteTimesXYZFloat")
inline operator fun Byte.times(other: XYZ<Float>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZFloatDivScalarByte")
inline operator fun XYZ<Float>.div(other: Byte) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarByteDivXYZFloat")
inline operator fun Byte.div(other: XYZ<Float>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZFloatTimesScalarInt")
inline operator fun XYZ<Float>.times(other: Int) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarIntTimesXYZFloat")
inline operator fun Int.times(other: XYZ<Float>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZFloatDivScalarInt")
inline operator fun XYZ<Float>.div(other: Int) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarIntDivXYZFloat")
inline operator fun Int.div(other: XYZ<Float>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZFloatTimesScalarLong")
inline operator fun XYZ<Float>.times(other: Long) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarLongTimesXYZFloat")
inline operator fun Long.times(other: XYZ<Float>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZFloatDivScalarLong")
inline operator fun XYZ<Float>.div(other: Long) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarLongDivXYZFloat")
inline operator fun Long.div(other: XYZ<Float>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZFloatTimesScalarFloat")
inline operator fun XYZ<Float>.times(other: Float) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarFloatTimesXYZFloat")
inline operator fun Float.times(other: XYZ<Float>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZFloatDivScalarFloat")
inline operator fun XYZ<Float>.div(other: Float) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarFloatDivXYZFloat")
inline operator fun Float.div(other: XYZ<Float>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZFloatTimesScalarDouble")
inline operator fun XYZ<Float>.times(other: Double) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarDoubleTimesXYZFloat")
inline operator fun Double.times(other: XYZ<Float>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZFloatDivScalarDouble")
inline operator fun XYZ<Float>.div(other: Double) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarDoubleDivXYZFloat")
inline operator fun Double.div(other: XYZ<Float>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZDoubleTimesScalarShort")
inline operator fun XYZ<Double>.times(other: Short) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarShortTimesXYZDouble")
inline operator fun Short.times(other: XYZ<Double>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZDoubleDivScalarShort")
inline operator fun XYZ<Double>.div(other: Short) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarShortDivXYZDouble")
inline operator fun Short.div(other: XYZ<Double>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZDoubleTimesScalarByte")
inline operator fun XYZ<Double>.times(other: Byte) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarByteTimesXYZDouble")
inline operator fun Byte.times(other: XYZ<Double>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZDoubleDivScalarByte")
inline operator fun XYZ<Double>.div(other: Byte) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarByteDivXYZDouble")
inline operator fun Byte.div(other: XYZ<Double>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZDoubleTimesScalarInt")
inline operator fun XYZ<Double>.times(other: Int) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarIntTimesXYZDouble")
inline operator fun Int.times(other: XYZ<Double>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZDoubleDivScalarInt")
inline operator fun XYZ<Double>.div(other: Int) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarIntDivXYZDouble")
inline operator fun Int.div(other: XYZ<Double>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZDoubleTimesScalarLong")
inline operator fun XYZ<Double>.times(other: Long) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarLongTimesXYZDouble")
inline operator fun Long.times(other: XYZ<Double>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZDoubleDivScalarLong")
inline operator fun XYZ<Double>.div(other: Long) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarLongDivXYZDouble")
inline operator fun Long.div(other: XYZ<Double>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZDoubleTimesScalarFloat")
inline operator fun XYZ<Double>.times(other: Float) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarFloatTimesXYZDouble")
inline operator fun Float.times(other: XYZ<Double>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZDoubleDivScalarFloat")
inline operator fun XYZ<Double>.div(other: Float) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarFloatDivXYZDouble")
inline operator fun Float.div(other: XYZ<Double>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

@JvmName("XYZDoubleTimesScalarDouble")
inline operator fun XYZ<Double>.times(other: Double) = XYZ(
	x = this.x * other,
	y = this.y * other,
	z = this.z * other
)

@JvmName("ScalarDoubleTimesXYZDouble")
inline operator fun Double.times(other: XYZ<Double>) = XYZ(
	x = this * other.x,
	y = this * other.y,
	z = this * other.z
)

@JvmName("XYZDoubleDivScalarDouble")
inline operator fun XYZ<Double>.div(other: Double) = XYZ(
	x = this.x / other,
	y = this.y / other,
	z = this.z / other
)

@JvmName("ScalarDoubleDivXYZDouble")
inline operator fun Double.div(other: XYZ<Double>) = XYZ(
	x = this / other.x,
	y = this / other.y,
	z = this / other.z
)

