/*
 * Decompiled with CFR 0.152.
 */
package neat.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import neat.NumberFormatter;
import neat.NumberFormatterOptions;
import neat.NumberFormatterRawOptions;
import neat.NumberFormatterRawOptionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lneat/internal/NumberFormatterImpl;", "Lneat/NumberFormatter;", "options", "Lneat/NumberFormatterRawOptions;", "<init>", "(Lneat/NumberFormatterRawOptions;)V", "getOptions", "()Lneat/NumberFormatterRawOptions;", "finalizeDecimals", "", "amount", "", "Lneat/NumberFormatterOptions;", "format", "number", "", "neat-formatting"})
@SourceDebugExtension(value={"SMAP\nNumberFormatterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormatterImpl.kt\nneat/internal/NumberFormatterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public class NumberFormatterImpl
implements NumberFormatter {
    @NotNull
    private final NumberFormatterRawOptions options;

    @JvmOverloads
    public NumberFormatterImpl(@NotNull NumberFormatterRawOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    public /* synthetic */ NumberFormatterImpl(NumberFormatterRawOptions numberFormatterRawOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            numberFormatterRawOptions = new NumberFormatterOptions(false, null, null, 0, false, null, null, 127, null);
        }
        this(numberFormatterRawOptions);
    }

    @Override
    @NotNull
    public NumberFormatterRawOptions getOptions() {
        return this.options;
    }

    private final String finalizeDecimals(double amount, NumberFormatterOptions options) {
        Object object;
        if (!options.getEnforceDecimals().booleanValue()) {
            if (StringsKt.endsWith$default((String)String.valueOf(amount), (String)".0", (boolean)false, (int)2, null)) {
                return String.valueOf((int)amount);
            }
            object = String.valueOf(amount);
        } else {
            if (StringsKt.endsWith$default((String)String.valueOf(amount), (String)".0", (boolean)false, (int)2, null)) {
                String mantisa = StringsKt.repeat((CharSequence)"0", (int)options.getDecimals());
                return (int)amount + "." + mantisa;
            }
            String[] stringArray = new String[]{"."};
            String mantisa = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)String.valueOf(amount), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1);
            if (mantisa == null) {
                object = amount + "." + StringsKt.repeat((CharSequence)"0", (int)options.getDecimals());
            } else {
                Object object2;
                Object object3 = new String[]{"."};
                int n = 1;
                object3 = StringsKt.split$default((CharSequence)String.valueOf(amount), (String[])object3, (boolean)false, (int)0, (int)6, null);
                if (n < object3.size()) {
                    object2 = object3.get(n);
                } else {
                    int it = n;
                    boolean bl = false;
                    object2 = "";
                }
                int numberOfDecimals = ((String)object2).length();
                object = amount + StringsKt.repeat((CharSequence)"0", (int)(options.getDecimals() - numberOfDecimals));
            }
        }
        return object;
    }

    @Override
    @NotNull
    public String format(@NotNull Number number) {
        String string;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        if (Intrinsics.areEqual((Object)this.getOptions().getAbbreviate(), (Object)true)) {
            Integer n = this.getOptions().getDecimals();
            NumberFormatterOptions opt = NumberFormatterOptions.copy$default(NumberFormatterRawOptionsKt.toFormatterOptions(this.getOptions()), false, null, null, n != null ? n : NumberFormatterOptions.DEFAULT_DECIMALS_ABBREVIATED, false, null, null, 119, null);
            double value = number.doubleValue();
            Pair pair = value < 1000.0 ? TuplesKt.to((Object)"", (Object)1) : (value >= 1000.0 && value < 1000000.0 ? TuplesKt.to((Object)"K", (Object)1000) : (value >= 1000000.0 && value < 1.0E9 ? TuplesKt.to((Object)"M", (Object)1000000) : TuplesKt.to((Object)"B", (Object)1000000000)));
            String postfix = (String)pair.component1();
            int divider = ((Number)pair.component2()).intValue();
            double rounded = Math.rint(value * opt.getRounder() / (double)divider) / opt.getRounder();
            string = opt.getPrefix() + this.finalizeDecimals(rounded, opt) + postfix;
        } else {
            Object object;
            Object object2;
            Integer n = this.getOptions().getDecimals();
            NumberFormatterOptions opt = NumberFormatterOptions.copy$default(NumberFormatterRawOptionsKt.toFormatterOptions(this.getOptions()), false, null, null, n != null ? n : NumberFormatterOptions.DEFAULT_DECIMALS_UNABBREVIATED, false, null, null, 119, null);
            double value = Math.rint(number.doubleValue() * opt.getRounder()) / opt.getRounder();
            char[] postfix = new char[]{'.'};
            List splits = StringsKt.split$default((CharSequence)String.valueOf(value), (char[])postfix, (boolean)false, (int)0, (int)6, null);
            String characteristic = (String)splits.get(0);
            int n2 = 1;
            List rounded = splits;
            if (n2 < rounded.size()) {
                object2 = rounded.get(n2);
            } else {
                int it = n2;
                boolean bl = false;
                object2 = "0";
            }
            String mantisa = (String)object2;
            mantisa = Double.parseDouble(mantisa) == 0.0 ? "" : mantisa;
            char[] cArray = characteristic.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            characteristic = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.chunked((Iterable)CollectionsKt.reversed((Iterable)ArraysKt.toList((char[])cArray)), (int)3)), (CharSequence)opt.getThousandsSeparator(), null, null, (int)0, null, NumberFormatterImpl::format$lambda$2, (int)30, null);
            String finalizedValue = this.finalizeDecimals(value, opt);
            Object object3 = new String[]{"."};
            object3 = StringsKt.split$default((CharSequence)finalizedValue, (String[])object3, (boolean)false, (int)0, (int)6, null);
            int n3 = 1;
            if (n3 < object3.size()) {
                object = object3.get(n3);
            } else {
                int it = n3;
                boolean bl = false;
                object = "";
            }
            String mts = (String)object;
            string = opt.getEnforceDecimals() != false && Intrinsics.areEqual((Object)mantisa, (Object)"") ? opt.getPrefix() + characteristic + "." + mts + opt.getPostfix() : (Intrinsics.areEqual((Object)mantisa, (Object)"") ? opt.getPrefix() + characteristic + opt.getPostfix() : opt.getPrefix() + characteristic + opt.getDecimalSeparator() + mts + opt.getPostfix());
        }
        return string;
    }

    @Override
    @NotNull
    public String format(double number) {
        Intrinsics.checkNotNull((Object)number, (String)"null cannot be cast to non-null type kotlin.Number");
        return this.format((Number)number);
    }

    @JvmOverloads
    public NumberFormatterImpl() {
        this(null, 1, null);
    }

    private static final CharSequence format$lambda$2(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)it), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

