/*
 * Decompiled with CFR 0.152.
 */
package uk.autores;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import uk.autores.processing.ConfigDef;

public final class ConfigDefs {
    public static final ConfigDef VISIBILITY = new ConfigDef("visibility", "public"::equals, "Generated class visibility. Valid value: \"public\"");
    public static final ConfigDef ENCODING = new ConfigDef("encoding", Charset.availableCharsets()::containsKey, "The canonical name of a supported encoding: " + Charset.availableCharsets().keySet());
    public static final ConfigDef LOCALIZE = new ConfigDef("localize", s -> s.matches("true|false"), "Enables searching for localized resources. Valid values: \"true\"; \"false\".");
    public static final ConfigDef MISSING_KEY = new ConfigDef("missing-key", s -> s.matches("error|warn|ignore"), "Action when a base key is missing from localized file. Valid values: \"error\"; \"warn\"; \"ignore\".");
    public static final ConfigDef FORMAT = new ConfigDef("format", s -> s.matches("true|false"), "Enables formatting. Valid values: \"true\"; \"false\".");
    public static final ConfigDef STRATEGY = new ConfigDef("strategy", s -> s.matches("auto|inline|lazy"), "Code generation strategy. Valid values: \"auto\"; \"inline\"; \"lazy\".");

    private ConfigDefs() {
    }

    static Set<ConfigDef> set(ConfigDef ... defs) {
        LinkedHashSet<ConfigDef> set = new LinkedHashSet<ConfigDef>();
        Collections.addAll(set, defs);
        return set;
    }

    public static final class Names {
        public static final String VISIBILITY = "visibility";
        public static final String ENCODING = "encoding";
        public static final String MISSING_KEY = "missing-key";
        public static final String LOCALIZE = "localize";
        public static final String FORMAT = "format";
        public static final String STRATEGY = "strategy";

        private Names() {
        }
    }
}

