/*
 * Decompiled with CFR 0.152.
 */
package uk.autores;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.processing.Filer;
import javax.tools.JavaFileObject;
import uk.autores.ConfigDefs;
import uk.autores.internal.Ints;
import uk.autores.internal.JavaWriter;
import uk.autores.internal.UnicodeEscapeWriter;
import uk.autores.processing.ConfigDef;
import uk.autores.processing.Context;
import uk.autores.processing.Handler;
import uk.autores.processing.Namer;
import uk.autores.processing.Pkg;
import uk.autores.processing.Resource;

public final class GenerateByteArraysFromFiles
implements Handler {
    private static final int MAX_BYTES_PER_METHOD = 8191;

    @Override
    public Set<ConfigDef> config() {
        return ConfigDefs.set(ConfigDefs.VISIBILITY, ConfigDefs.STRATEGY);
    }

    @Override
    public void handle(Context context) throws Exception {
        SortedSet<Resource> resources = context.resources();
        Namer namer = context.namer();
        Pkg pkg = context.pkg();
        Filer filer = context.env().getFiler();
        ClassGenerator generator = this.generatorStrategy(context);
        byte[] buf = new byte[8191];
        for (Resource entry : resources) {
            String resource = entry.path();
            String simple = namer.simplifyResourceName(resource);
            String className = namer.nameClass(simple);
            String qualifiedName = pkg.qualifiedClassName(className);
            if (!Namer.isJavaIdentifier(className)) {
                String msg = "Cannot transform resource name '" + resource + "' to class name";
                context.printError(msg);
                continue;
            }
            FileStats stats = GenerateByteArraysFromFiles.stats(buf, entry);
            if (stats.size > Integer.MAX_VALUE) {
                String err = "Resource " + resource + " too big for byte array; max size is 2147483647";
                context.printError(err);
                continue;
            }
            JavaFileObject javaFile = filer.createSourceFile(qualifiedName, context.annotated());
            Writer out = javaFile.openWriter();
            try (UnicodeEscapeWriter escaper = new UnicodeEscapeWriter(out);
                 JavaWriter writer = new JavaWriter(this, context, escaper, className, resource);){
                generator.generate(writer, buf, stats);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private ClassGenerator generatorStrategy(Context context) {
        String strategy;
        switch (strategy = context.option(ConfigDefs.STRATEGY).orElse("auto")) {
            case "inline": {
                return GenerateByteArraysFromFiles::writeInlineMethods;
            }
            case "lazy": {
                return GenerateByteArraysFromFiles::writeLazyLoad;
            }
        }
        return GenerateByteArraysFromFiles::writeAuto;
    }

    private static void writeAuto(JavaWriter writer, byte[] buf, FileStats stats) throws IOException {
        if (stats.size > 1024L) {
            GenerateByteArraysFromFiles.writeLazyLoad(writer, buf, stats);
        } else {
            GenerateByteArraysFromFiles.writeInlineMethods(writer, buf, stats);
        }
    }

    private static void writeInlineMethods(JavaWriter writer, byte[] buf, FileStats stats) throws IOException {
        int methodCount = 0;
        try (InputStream in = stats.resource.open();){
            int r;
            while ((r = in.read(buf)) >= 0) {
                GenerateByteArraysFromFiles.writeInlineFillMethod(buf, r, writer, methodCount);
                ++methodCount;
            }
        }
        GenerateByteArraysFromFiles.writeInlineBytesMethod(writer, methodCount, (int)stats.size);
    }

    private static void writeInlineFillMethod(byte[] buf, int limit, JavaWriter writer, int index) throws IOException {
        writer.nl();
        writer.indent().append("private static int fill").append(Ints.toString(index)).append("(byte[] b, int i) ").openBrace().nl();
        for (int i = 0; i < limit; ++i) {
            byte b = buf[i];
            if (b == 0) {
                int skip = GenerateByteArraysFromFiles.inlineSkipZeroes(buf, i + 1, limit);
                String skipStr = Ints.toString(skip + 1);
                writer.indent().append("i += ").append(skipStr).append(";").nl();
                i += skip;
                continue;
            }
            String byteStr = Ints.toString(b);
            writer.indent().append("b[i++] = ").append(byteStr).append(";").nl();
        }
        writer.indent().append("return i;").nl();
        writer.closeBrace().nl();
    }

    private static int inlineSkipZeroes(byte[] buf, int offset, int limit) {
        for (int i = offset; i < limit; ++i) {
            if (buf[i] == 0) continue;
            return i - offset;
        }
        return limit - offset;
    }

    private static void writeInlineBytesMethod(JavaWriter writer, int methodCount, int size) throws IOException {
        GenerateByteArraysFromFiles.writeSignature(writer);
        writer.indent().append("byte[] barr = new byte[").append(Ints.toString(size)).append("];").nl();
        writer.indent().append("int idx = 0;").nl();
        for (int i = 0; i < methodCount; ++i) {
            String n = Ints.toString(i);
            writer.indent().append("idx = fill").append(n).append("(barr, idx);").nl();
        }
        GenerateByteArraysFromFiles.writeReturn(writer);
    }

    private static void writeLazyLoad(JavaWriter writer, byte[] buf, FileStats stats) throws IOException {
        GenerateByteArraysFromFiles.writeSignature(writer);
        writer.indent().append("byte[] barr = new byte[").append(Ints.toString((int)stats.size)).append("];").nl();
        writer.indent().append("try (java.io.InputStream in = ").openResource(stats.resource.path()).append(") ").openBrace().nl();
        writer.indent().append("int offset = 0;").nl();
        writer.indent().append("while(true) ").openBrace().nl();
        writer.indent().append("int r = in.read(barr, offset, barr.length - offset);").nl();
        writer.indent().append("if (r < 0) { break; }").nl();
        writer.indent().append("offset += r;").nl();
        writer.indent().append("if (offset == barr.length) { break; }").nl();
        writer.closeBrace().nl();
        writer.throwOnModification("(offset != barr.length) || (in.read() >= 0)", stats.resource.path());
        writer.closeBrace().append(" catch(java.io.IOException e) ").openBrace().nl();
        writer.indent().append("throw new AssertionError(").string(stats.resource.path()).append(", e);").nl();
        writer.closeBrace().nl();
        GenerateByteArraysFromFiles.writeReturn(writer);
    }

    private static void writeSignature(JavaWriter writer) throws IOException {
        writer.nl();
        writer.indent().staticMember("byte[]", "bytes").append("() ").openBrace().nl();
    }

    private static void writeReturn(JavaWriter writer) throws IOException {
        writer.indent().append("return barr;").nl();
        writer.closeBrace().nl();
    }

    private static FileStats stats(byte[] buf, Resource resource) throws IOException {
        long size = 0L;
        try (InputStream in = resource.open();){
            int r;
            do {
                if ((r = in.read(buf)) >= 0) continue;
                break;
            } while ((size += (long)r) <= Integer.MAX_VALUE);
        }
        return new FileStats(resource, size);
    }

    @FunctionalInterface
    private static interface ClassGenerator {
        public void generate(JavaWriter var1, byte[] var2, FileStats var3) throws IOException;
    }

    private static final class FileStats {
        private final Resource resource;
        private final long size;

        private FileStats(Resource resource, long size) {
            this.resource = resource;
            this.size = size;
        }
    }
}

