/*
 * Decompiled with CFR 0.152.
 */
package uk.autores;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.tools.JavaFileObject;
import uk.autores.ConfigDefs;
import uk.autores.internal.JavaWriter;
import uk.autores.internal.PropLoader;
import uk.autores.internal.UnicodeEscapeWriter;
import uk.autores.processing.ConfigDef;
import uk.autores.processing.Context;
import uk.autores.processing.Handler;
import uk.autores.processing.Namer;
import uk.autores.processing.Resource;

public final class GenerateConstantsFromProperties
implements Handler {
    private static final String EXTENSION = ".properties";

    @Override
    public Set<ConfigDef> config() {
        return ConfigDefs.set(ConfigDefs.VISIBILITY);
    }

    @Override
    public void handle(Context context) throws Exception {
        for (Resource res : context.resources()) {
            if (!res.path().endsWith(EXTENSION)) {
                String msg = "Resource names must end in .properties - got " + res.path();
                context.printError(msg);
                continue;
            }
            Properties base = PropLoader.load(res);
            this.writeProperties(context, res, base);
        }
    }

    private void writeProperties(Context ctxt, Resource resource, Properties base) throws IOException {
        String simple;
        TreeSet<String> keys = new TreeSet<String>(base.stringPropertyNames());
        Namer namer = ctxt.namer();
        String name = namer.nameClass(simple = namer.simplifyResourceName(resource.path()));
        if (!Namer.isJavaIdentifier(name)) {
            String msg = "Cannot transform '" + resource + "' into class name.";
            ctxt.printError(msg);
            return;
        }
        String qualified = ctxt.pkg().qualifiedClassName(name);
        Filer filer = ctxt.env().getFiler();
        JavaFileObject jfo = filer.createSourceFile(qualified, ctxt.annotated());
        try (Writer out = jfo.openWriter();
             UnicodeEscapeWriter escaper = new UnicodeEscapeWriter(out);
             JavaWriter writer = new JavaWriter(this, ctxt, escaper, name, resource.path());){
            for (String key : keys) {
                this.writeProperty(ctxt, resource, writer, key);
            }
        }
    }

    private void writeProperty(Context ctxt, Resource resource, JavaWriter writer, String key) throws IOException {
        String field = ctxt.namer().nameStaticField(key);
        if (!Namer.isJavaIdentifier(field)) {
            String msg = "Cannot transform key '" + key + "' in " + resource + " to field name";
            ctxt.printError(msg);
            return;
        }
        writer.indent().staticFinal("java.lang.String", field).string(key).append(";").nl();
    }
}

