/*
 * Decompiled with CFR 0.152.
 */
package uk.autores;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import uk.autores.ConfigDefs;
import uk.autores.internal.JavaWriter;
import uk.autores.internal.MessageParser;
import uk.autores.internal.PropLoader;
import uk.autores.internal.Reporting;
import uk.autores.internal.UnicodeEscapeWriter;
import uk.autores.processing.ConfigDef;
import uk.autores.processing.Context;
import uk.autores.processing.Handler;
import uk.autores.processing.Namer;
import uk.autores.processing.Pkg;
import uk.autores.processing.Resource;

public final class GenerateMessagesFromProperties
implements Handler {
    private static final String EXTENSION = ".properties";

    @Override
    public Set<ConfigDef> config() {
        return ConfigDefs.set(ConfigDefs.VISIBILITY, ConfigDefs.LOCALIZE, ConfigDefs.MISSING_KEY, ConfigDefs.FORMAT);
    }

    @Override
    public void handle(Context context) throws IOException {
        SortedSet<Resource> resources = context.resources();
        boolean localize = !context.option(ConfigDefs.LOCALIZE).filter("false"::equals).isPresent();
        for (Resource res : resources) {
            if (!res.path().endsWith(EXTENSION)) {
                String msg = "Resource names must end in .properties - got " + res;
                context.printError(msg);
                continue;
            }
            Properties base = PropLoader.load(res);
            List<Localized> localizations = localize ? this.loadLocalizations(context, res) : Collections.emptyList();
            this.writeProperties(context, res, base, localizations);
        }
    }

    private List<Localized> loadLocalizations(Context context, Resource resource) throws IOException {
        String name = resource.filerPath();
        Filer filer = context.env().getFiler();
        JavaFileManager.Location location = context.location();
        String resourcePackage = context.pkg().resourcePackage();
        ArrayList<Localized> localized = new ArrayList<Localized>();
        int end = name.length() - EXTENSION.length();
        String base = name.substring(0, end);
        for (Map.Entry<String, Locale> entry : this.expandedLocales().entrySet()) {
            FileObject file;
            String pattern = entry.getKey();
            Locale locale = entry.getValue();
            if (locale.getLanguage().isEmpty()) continue;
            String props = base + pattern + EXTENSION;
            try {
                file = filer.getResource(location, resourcePackage, props);
                try (InputStream in = file.openInputStream();){
                    Objects.requireNonNull(in);
                }
            }
            catch (IOException e) {
                continue;
            }
            Resource res = new Resource(file, props);
            Properties properties = PropLoader.load(res);
            localized.add(new Localized(pattern, properties));
        }
        return localized;
    }

    private void writeProperties(Context ctxt, Resource resource, Properties base, List<Localized> localizations) throws IOException {
        Namer namer = ctxt.namer();
        Pkg pkg = ctxt.pkg();
        Filer filer = ctxt.env().getFiler();
        TreeSet<String> keys = new TreeSet<String>(base.stringPropertyNames());
        String simple = namer.simplifyResourceName(resource.path());
        String name = namer.nameClass(simple);
        if (!Namer.isJavaIdentifier(name)) {
            String msg = "Cannot transform resource '" + resource + "' into class name";
            ctxt.printError(msg);
            return;
        }
        String qualified = pkg.qualifiedClassName(name);
        String lookupName = String.format("pattern$%s$%x", name, name.hashCode());
        JavaFileObject jfo = filer.createSourceFile(qualified, ctxt.annotated());
        try (Writer out = jfo.openWriter();
             UnicodeEscapeWriter escaper = new UnicodeEscapeWriter(out);
             JavaWriter writer = new JavaWriter(this, ctxt, escaper, name, resource.path());){
            Msgs msgs = new Msgs(resource, lookupName, localizations, writer);
            if (!localizations.isEmpty()) {
                this.writeCache(writer, name, lookupName, localizations);
            }
            for (String key : keys) {
                this.writeProperty(ctxt, msgs, key, base.getProperty(key));
            }
        }
    }

    private void writeCache(JavaWriter writer, String name, String lookupName, List<Localized> localizations) throws IOException {
        String cacheName = "CACHE$" + lookupName.toUpperCase(Locale.ENGLISH);
        String computeName = "compute$" + lookupName;
        writer.nl();
        writer.indent().append("private static final java.util.Map<java.util.Locale, java.lang.String> ").append(cacheName).append(" = new java.util.concurrent.ConcurrentHashMap<>();").nl();
        writer.nl();
        writer.indent().append("private static java.lang.String ").append(computeName).append("(java.util.Locale l) ").openBrace().nl();
        writer.indent().append("java.util.ResourceBundle.Control ctrl = java.util.ResourceBundle.Control.getControl(java.util.ResourceBundle.Control.FORMAT_PROPERTIES);").nl();
        writer.indent().append("for (java.util.Locale candidate : ctrl.getCandidateLocales(\"\", l)) ").openBrace().nl();
        writer.indent().append("if (candidate.getLanguage().isEmpty()) ").openBrace().nl();
        writer.indent().append("continue;").nl();
        writer.closeBrace().nl();
        writer.indent().append("java.lang.String pattern = ctrl.toBundleName(\"\", candidate).substring(1);").nl();
        writer.indent().append("switch (pattern) ").openBrace().nl();
        for (Localized l : localizations) {
            String p = l.pattern.substring(1);
            writer.indent().append("case \"").append(p).append("\": return \"").append(p).append("\";").nl();
        }
        writer.closeBrace().nl();
        writer.closeBrace().nl();
        writer.indent().append("return \"\";").nl();
        writer.closeBrace().nl();
        writer.nl();
        writer.indent().append("private static java.lang.String ").append(lookupName).append("(java.util.Locale l) ").openBrace().nl();
        writer.indent().append("return ").append(cacheName).append(".computeIfAbsent(l, ").append(name).append("::").append(computeName).append(");").nl();
        writer.closeBrace().nl();
    }

    private void writeProperty(Context ctxt, Msgs msgs, String key, String baseValue) throws IOException {
        Resource resource = msgs.resource;
        String method = ctxt.namer().nameMethod(key);
        if (!Namer.isJavaIdentifier(method)) {
            String msg = "Cannot transform key '" + key + "' in " + resource + " to method name";
            ctxt.printError(msg);
            return;
        }
        JavaWriter writer = msgs.writer;
        List<Localized> localizations = msgs.localizations;
        writer.nl().comment(key);
        if (localizations.isEmpty()) {
            writer.indent().staticMember("java.lang.String", method).append("() ").openBrace().nl();
        } else {
            String lookupName = msgs.lookupName;
            writer.indent().staticMember("java.lang.String", method).append("(java.util.Locale l) ").openBrace().nl();
            writer.indent().append("java.lang.String pattern = ").append(lookupName).append("(l);").nl();
            writer.indent().append("switch (pattern) ").openBrace().nl();
            for (Localized l : localizations) {
                String value = l.properties.getProperty(key);
                if (value == null) {
                    String msg = resource + ": " + l.pattern + ": missing key " + key;
                    Reporting.reporter(ctxt, ConfigDefs.MISSING_KEY).accept(msg);
                    continue;
                }
                String pattern = l.pattern.substring(1);
                writer.indent().append("case ").string(pattern).append(": return ").string(value).append(";").nl();
            }
            writer.closeBrace().nl();
        }
        writer.indent().append("return ").string(baseValue).append(";").nl();
        writer.closeBrace().nl();
        this.writeFormat(ctxt, msgs, writer, key, baseValue, method);
    }

    private void writeFormat(Context ctxt, Msgs msgs, JavaWriter writer, String key, String baseValue, String method) throws IOException {
        int i;
        if (ctxt.option(ConfigDefs.FORMAT).filter("false"::equals).isPresent()) {
            return;
        }
        List<MessageParser.VarType> vars = MessageParser.parse(baseValue);
        if (vars.isEmpty()) {
            return;
        }
        Resource resource = msgs.resource;
        List<Localized> localizations = msgs.localizations;
        if (!this.localizedMessagesMatchBase(ctxt, resource, vars, localizations, key)) {
            return;
        }
        boolean needsTimeZone = MessageParser.needsTimeZone(vars);
        boolean needsLocaleForFormat = MessageParser.needsLocale(vars);
        boolean hasLocalizedMsg = !localizations.isEmpty();
        boolean comma = false;
        writer.nl().comment(key);
        writer.indent().staticMember("java.lang.String", method).append("(");
        if (needsLocaleForFormat || hasLocalizedMsg) {
            writer.append("java.util.Locale l");
            comma = true;
        }
        if (needsTimeZone) {
            if (comma) {
                writer.append(", ");
            }
            writer.append("java.util.TimeZone tz");
            comma = true;
        }
        for (i = 0; i < vars.size(); ++i) {
            if (comma) {
                writer.append(", ");
            }
            comma = true;
            MessageParser.VarType vt = vars.get(i);
            writer.append(vt.type).append(" v").append(Integer.toString(i));
        }
        writer.append(") ").openBrace().nl();
        writer.indent().append("java.lang.String msg = ").append(method);
        if (hasLocalizedMsg) {
            writer.append("(l);").nl();
        } else {
            writer.append("();").nl();
        }
        if (needsLocaleForFormat || hasLocalizedMsg) {
            writer.indent().append("java.text.MessageFormat formatter = new java.text.MessageFormat(msg, l);").nl();
        } else {
            writer.indent().append("java.text.MessageFormat formatter = new java.text.MessageFormat(msg);").nl();
        }
        if (needsTimeZone) {
            writer.indent().append("java.lang.Object[] fmts = formatter.getFormats();").nl();
            writer.indent().append("for (int i = 0, len = fmts.length; i < len; i++) ").openBrace().nl();
            writer.indent().append("if (fmts[i] instanceof java.text.DateFormat) ").openBrace().nl();
            writer.indent().append("((java.text.DateFormat) fmts[i]).setTimeZone(tz);").nl();
            writer.closeBrace().nl();
            writer.closeBrace();
        }
        writer.indent().append("java.lang.Object[] args = ").openBrace().nl();
        for (i = 0; i < vars.size(); ++i) {
            boolean date = vars.get(i) == MessageParser.VarType.DATE;
            writer.indent();
            if (date) {
                writer.append("java.util.Date.from(");
            }
            writer.append("v");
            writer.append(Integer.toString(i));
            if (date) {
                writer.append(")");
            }
            writer.append(",").nl();
        }
        writer.closeBrace().append(";").nl();
        writer.indent().append("return formatter.format(args, new java.lang.StringBuffer(), null).toString();").nl();
        writer.closeBrace().nl();
    }

    private boolean localizedMessagesMatchBase(Context ctxt, Resource resource, List<MessageParser.VarType> vars, List<Localized> localizations, String key) {
        boolean ok = true;
        for (Localized l : localizations) {
            List<MessageParser.VarType> locVars;
            String localizedValue = l.properties.getProperty(key);
            if (localizedValue == null || (locVars = MessageParser.parse(localizedValue)).equals(vars)) continue;
            String msg = "Differing message variables in localization " + resource + ": " + l.pattern + ": ";
            msg = msg + "key=" + key + " have " + locVars + " need " + vars;
            ctxt.printError(msg);
            ok = false;
        }
        return ok;
    }

    private List<Locale> locales() {
        return Arrays.asList(Locale.getAvailableLocales());
    }

    private SortedMap<String, Locale> expandedLocales() {
        ResourceBundle.Control ctrl = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        TreeMap<String, Locale> map = new TreeMap<String, Locale>();
        for (Locale base : this.locales()) {
            if (base.getLanguage().isEmpty()) continue;
            for (Locale locale : ctrl.getCandidateLocales("", base)) {
                String pattern = ctrl.toBundleName("", locale);
                map.put(pattern, locale);
            }
        }
        return map;
    }

    private static class Msgs {
        private final Resource resource;
        private final String lookupName;
        private final List<Localized> localizations;
        private final JavaWriter writer;

        private Msgs(Resource resource, String lookupName, List<Localized> localizations, JavaWriter writer) {
            this.resource = resource;
            this.lookupName = lookupName;
            this.localizations = localizations;
            this.writer = writer;
        }
    }

    private static class Localized {
        final String pattern;
        final Properties properties;

        private Localized(String pattern, Properties properties) {
            this.pattern = pattern;
            this.properties = properties;
        }
    }
}

