/*
 * Decompiled with CFR 0.152.
 */
package uk.autores;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import uk.autores.ConfigDefs;
import uk.autores.internal.Ints;
import uk.autores.internal.JavaWriter;
import uk.autores.internal.UnicodeEscapeWriter;
import uk.autores.internal.Utf8Buffer;
import uk.autores.processing.ConfigDef;
import uk.autores.processing.Context;
import uk.autores.processing.Handler;
import uk.autores.processing.Namer;
import uk.autores.processing.Pkg;
import uk.autores.processing.Resource;

public final class GenerateStringsFromText
implements Handler {
    private static final int CONST_BYTE_LIMIT = 65535;

    @Override
    public Set<ConfigDef> config() {
        return ConfigDefs.set(ConfigDefs.VISIBILITY, ConfigDefs.ENCODING, ConfigDefs.STRATEGY);
    }

    @Override
    public void handle(Context context) throws Exception {
        SortedSet<Resource> resources = context.resources();
        Namer namer = context.namer();
        Pkg pkg = context.pkg();
        Filer filer = context.env().getFiler();
        Element annotated = context.annotated();
        String encoding = context.option(ConfigDefs.ENCODING).orElse("UTF-8");
        CharsetDecoder decoder = this.decoder(encoding);
        Utf8Buffer buf = Utf8Buffer.size(65535);
        Assistants assistants = new Assistants(decoder, buf);
        ClassGenerator generator = this.strategy(context);
        for (Resource res : resources) {
            String resource = res.path();
            Stats stats = this.stats(res, buf, decoder);
            if (stats.utf16Size > Integer.MAX_VALUE) {
                String msg = "Resource " + resource + " to large for String type";
                context.printError(msg);
                continue;
            }
            String simple = namer.simplifyResourceName(resource);
            String className = namer.nameClass(simple);
            String qualifiedName = pkg.qualifiedClassName(className);
            if (!Namer.isJavaIdentifier(className)) {
                String msg = "Cannot transform resource name '" + res.path() + "' to class name";
                context.printError(msg);
                continue;
            }
            JavaFileObject javaFile = filer.createSourceFile(qualifiedName, annotated);
            Writer out = javaFile.openWriter();
            try (UnicodeEscapeWriter escaper = new UnicodeEscapeWriter(out);
                 JavaWriter writer = new JavaWriter(this, context, escaper, className, res.path());){
                generator.generate(assistants, stats, writer);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private ClassGenerator strategy(Context context) {
        String strategy;
        switch (strategy = context.option(ConfigDefs.STRATEGY).orElse("auto")) {
            case "lazy": {
                return GenerateStringsFromText::writeLazyLoad;
            }
            case "inline": {
                return GenerateStringsFromText::writeInLine;
            }
        }
        return GenerateStringsFromText::writeAuto;
    }

    private static void writeAuto(Assistants assistants, Stats stats, JavaWriter writer) throws IOException {
        if (stats.utf8Size > 65535L) {
            GenerateStringsFromText.writeLazyLoad(assistants, stats, writer);
        } else {
            GenerateStringsFromText.writeInLine(assistants, stats, writer);
        }
    }

    private static void writeInLine(Assistants assistants, Stats stats, JavaWriter writer) throws IOException {
        if (stats.utf8Size < 65535L) {
            GenerateStringsFromText.writeSimpleInline(assistants, stats, writer);
            return;
        }
        String len = Ints.toString((int)stats.utf16Size);
        Utf8Buffer buf = assistants.buffer;
        GenerateStringsFromText.writeMethodDeclaration(writer);
        try (InputStream in = stats.resource.open();
             InputStreamReader reader = new InputStreamReader(in, assistants.decoder);
             BufferedReader bufReader = new BufferedReader(reader);){
            writer.indent().append("char[] arr = new char[").append(len).append("];").nl();
            writer.indent().append("int offset = 0;").nl();
            while (buf.receive(bufReader)) {
                writer.indent().append("offset = copy(").string(buf).append(", arr, offset);").nl();
            }
            writer.indent().append("return new java.lang.String(arr);").nl();
        }
        GenerateStringsFromText.writeMethodClose(writer);
        GenerateStringsFromText.writeCopyMethod(writer);
    }

    private static void writeSimpleInline(Assistants assistants, Stats stats, JavaWriter writer) throws IOException {
        GenerateStringsFromText.writeMethodDeclaration(writer);
        try (InputStream in = stats.resource.open();
             InputStreamReader reader = new InputStreamReader(in, assistants.decoder);
             BufferedReader bufReader = new BufferedReader(reader, assistants.buffer.maxBuffer());){
            assistants.buffer.receive(bufReader);
            writer.indent().append("return ").string(assistants.buffer).append(";").nl();
        }
        GenerateStringsFromText.writeMethodClose(writer);
    }

    private static void writeLazyLoad(Assistants assistants, Stats stats, JavaWriter writer) throws IOException {
        String encoding = assistants.decoder.charset().name();
        int size = (int)stats.utf16Size;
        GenerateStringsFromText.writeMethodDeclaration(writer);
        writer.indent().append("java.nio.charset.Charset enc = java.nio.charset.Charset.forName(").string(encoding).append(");").nl();
        writer.indent().append("char[] buf = new char[").append(Ints.toString(size)).append("];").nl();
        writer.indent().append("try (").append("java.io.InputStream in = ").openResource(stats.resource.path()).append("; java.io.Reader reader = new java.io.InputStreamReader(in, enc)) ").openBrace().nl();
        writer.indent().append("int offset = 0;").nl();
        writer.indent().append("while(true) ").openBrace().nl();
        writer.indent().append("int r = reader.read(buf, offset, buf.length - offset);").nl();
        writer.indent().append("if (r < 0) { break; }").nl();
        writer.indent().append("offset += r;").nl();
        writer.indent().append("if (offset == buf.length) { break; }").nl();
        writer.closeBrace().nl();
        writer.throwOnModification("offset < buf.length || reader.read() >= 0", stats.resource.path());
        writer.closeBrace().append(" catch (java.io.IOException e) ").openBrace().nl();
        writer.indent().append("throw new AssertionError(").string(stats.resource.path()).append(");").nl();
        writer.closeBrace().nl();
        writer.indent().append("return new java.lang.String(buf);").nl();
        GenerateStringsFromText.writeMethodClose(writer);
    }

    private static void writeCopyMethod(JavaWriter writer) throws IOException {
        String decl = "private static int copy(java.lang.CharSequence src, char[] dest, int off) ";
        writer.nl();
        writer.indent().append(decl).openBrace().nl();
        writer.indent().append("for (int i = 0, len = src.length(); i < len; i++) ").openBrace().nl();
        writer.indent().append("dest[off++] = src.charAt(i);").nl();
        writer.closeBrace();
        writer.indent().append("return off;").nl();
        writer.closeBrace();
    }

    private static void writeMethodDeclaration(JavaWriter writer) throws IOException {
        writer.nl();
        writer.indent().staticMember("java.lang.String", "text").append("() ").openBrace().nl();
    }

    private static void writeMethodClose(JavaWriter writer) throws IOException {
        writer.closeBrace().nl();
    }

    private CharsetDecoder decoder(String encoding) {
        Charset c = Charset.forName(encoding);
        return c.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private Stats stats(Resource resource, Utf8Buffer buf, CharsetDecoder decoder) throws IOException {
        long utf16Size = 0L;
        long utf8Size = 0L;
        try (InputStream in = resource.open();
             InputStreamReader reader = new InputStreamReader(in, decoder);
             BufferedReader bufReader = new BufferedReader(reader);){
            while (buf.receive(bufReader)) {
                utf8Size += (long)buf.utf8Length();
                if ((utf16Size += (long)buf.length()) <= Integer.MAX_VALUE) continue;
                break;
            }
        }
        return new Stats(resource, utf16Size, utf8Size);
    }

    @FunctionalInterface
    private static interface ClassGenerator {
        public void generate(Assistants var1, Stats var2, JavaWriter var3) throws IOException;
    }

    private static final class Assistants {
        private final CharsetDecoder decoder;
        private final Utf8Buffer buffer;

        private Assistants(CharsetDecoder decoder, Utf8Buffer buffer) {
            this.decoder = decoder;
            this.buffer = buffer;
        }
    }

    private static final class Stats {
        private final Resource resource;
        private final long utf16Size;
        private final long utf8Size;

        private Stats(Resource resource, long utf16Size, long utf8Size) {
            this.resource = resource;
            this.utf16Size = utf16Size;
            this.utf8Size = utf8Size;
        }
    }
}

