/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.internal;

import java.io.IOException;
import java.io.Writer;
import uk.autores.ConfigDefs;
import uk.autores.internal.StringLiterals;
import uk.autores.processing.Context;
import uk.autores.processing.Pkg;

public final class JavaWriter
extends Writer {
    private static final String NL = System.lineSeparator();
    private final Writer w;
    private final String visibility;
    private final String className;
    private boolean closed = false;
    private int indentation = 2;

    public JavaWriter(Object generator, Context ctxt, Writer w, String className, String comment) throws IOException {
        this.w = w;
        this.className = className;
        this.visibility = ctxt.option(ConfigDefs.VISIBILITY).isPresent() ? "public " : "";
        w.append("// GENERATED CODE: ").append(generator.getClass().getName()).append(NL);
        Pkg pkg = ctxt.pkg();
        if (!pkg.isUnnamed()) {
            w.append("package ").append(pkg.name()).append(";").append(NL).append(NL);
        }
        if (!comment.isEmpty()) {
            w.append("/** \"");
            StringLiterals.write(comment, w);
            w.append("\" */").append(NL);
        }
        w.append(this.visibility).append("final class ").append(className).append(" {").append(NL);
        w.append("\n  private ").append(className).append("() {}").append(NL);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.w.write(cbuf, off, len);
    }

    @Override
    public JavaWriter append(CharSequence csq) throws IOException {
        this.w.append(csq);
        return this;
    }

    @Override
    public JavaWriter append(char c) throws IOException {
        this.w.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.w.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.w.append("}").append(NL);
        }
        finally {
            this.w.close();
        }
    }

    public JavaWriter nl() throws IOException {
        this.w.append(NL);
        return this;
    }

    public JavaWriter staticFinal(String type, String name) throws IOException {
        this.w.append(this.visibility).append("static final ").append(type).append(" ").append(name).append(" = ");
        return this;
    }

    public JavaWriter staticMember(String type, String name) throws IOException {
        this.w.append(this.visibility).append("static ").append(type).append(" ").append(name);
        return this;
    }

    public JavaWriter string(CharSequence value) throws IOException {
        this.w.append('\"');
        StringLiterals.write(value, this.w);
        this.w.append('\"');
        return this;
    }

    public JavaWriter comment(String comment) throws IOException {
        return this.append("  /** ").string(comment).append(" */").append(NL);
    }

    public JavaWriter openBrace() throws IOException {
        this.w.append('{');
        this.indentation += 2;
        return this;
    }

    public JavaWriter closeBrace() throws IOException {
        this.indentation -= 2;
        return this.indent().append('}');
    }

    public JavaWriter indent() throws IOException {
        for (int i = 0; i < this.indentation; ++i) {
            this.w.append(' ');
        }
        return this;
    }

    public JavaWriter openResource(String resource) throws IOException {
        return this.append(this.className).append(".class.getResourceAsStream(").string(resource).append(")");
    }

    public JavaWriter throwOnModification(String predicate, String resource) throws IOException {
        String err = "Resource modified after compilation: ";
        this.indent().append("if (").append(predicate).append(") ").openBrace().nl();
        this.indent().append("throw new AssertionError(").string(err).append("+").string(resource).append(");").nl();
        this.closeBrace().nl();
        return this;
    }
}

