/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.internal;

import java.util.Optional;
import uk.autores.processing.Config;
import uk.autores.processing.ConfigDef;
import uk.autores.processing.Context;
import uk.autores.processing.Handler;

public final class OptionValidation {
    private OptionValidation() {
    }

    public static boolean areValid(Handler handler, Context context) {
        if (!handler.validateConfig()) {
            return true;
        }
        String err = "";
        for (Config option : context.config()) {
            long c = context.config().stream().filter(o -> option.key().equals(o.key())).count();
            Optional<ConfigDef> def = handler.config().stream().filter(o -> o.name().equals(option.key())).findFirst();
            if (def.isPresent()) {
                ConfigDef od = def.get();
                if (c > 1L) {
                    err = String.format("%sDuplicate configuration option %s%n", err, option.key());
                }
                if (od.isValid(option.value())) continue;
                err = String.format("%sInvalid value %s=%s%n", err, option.key(), option.value());
                continue;
            }
            err = String.format("%sUnknown configuration option %s%n", err, option.key());
        }
        if (err.isEmpty()) {
            return true;
        }
        err = String.format("%s%nUsage:%n", err);
        for (ConfigDef def : handler.config()) {
            err = String.format("%s %s\t%s%n", err, def.name(), def.description());
        }
        context.printError(err);
        return false;
    }
}

