/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public final class UnicodeEscapeWriter
extends Writer {
    private final Writer w;
    private final StringBuilder b = new StringBuilder();
    boolean closed = false;

    public UnicodeEscapeWriter(Writer w) {
        this.w = Objects.requireNonNull(w);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkClosed();
        for (int i = 0; i < len; ++i) {
            this.buffer(cbuf[i]);
        }
        this.checkBuffer();
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.checkClosed();
        for (int i = 0; i < csq.length(); ++i) {
            this.buffer(csq.charAt(i));
        }
        this.checkBuffer();
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.checkClosed();
        this.buffer(c);
        this.checkBuffer();
        return this;
    }

    private void buffer(char c) {
        if (c > '\u007f') {
            this.b.append(String.format("\\u%04x", c));
        } else {
            this.b.append(c);
        }
    }

    private void checkBuffer() throws IOException {
        if (this.b.length() >= 65536) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        try {
            this.w.append(this.b);
        }
        finally {
            this.b.delete(0, this.b.length());
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.w.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.flush();
        }
        finally {
            this.w.close();
        }
    }
}

