/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.internal;

import java.io.IOException;
import java.io.Reader;

public final class Utf8Buffer
implements CharSequence {
    private final char[] cbuf;
    private int length = 0;
    private int utf8Length = 0;
    private final int maxUtf8Length;

    private Utf8Buffer(int size) {
        this.cbuf = new char[size * 2];
        this.maxUtf8Length = size;
    }

    public boolean receive(Reader reader) throws IOException {
        this.length = 0;
        this.utf8Length = 0;
        reader.mark(this.cbuf.length);
        int r = reader.read(this.cbuf);
        if (r < 0) {
            return false;
        }
        if (r == 0) {
            return true;
        }
        for (int i = 0; i < r; ++i) {
            int utf6Len;
            int codePoint;
            int ch = this.cbuf[i];
            if (ch <= 127) {
                if (this.maxUtf8Length == this.utf8Length + 1) break;
                ++this.utf8Length;
                ++this.length;
                continue;
            }
            if (Character.isSurrogate((char)ch)) {
                char low;
                this.throwMalformed(r == 1);
                if (i == r - 1) break;
                this.throwMalformed(!Character.isSurrogatePair((char)ch, low = this.cbuf[++i]));
                codePoint = Character.toCodePoint((char)ch, low);
                utf6Len = 2;
            } else {
                codePoint = ch;
                utf6Len = 1;
            }
            int bytes = Utf8Buffer.utf8Bytes(codePoint);
            if (bytes + this.utf8Length > this.maxUtf8Length) break;
            this.utf8Length += bytes;
            this.length += utf6Len;
        }
        reader.reset();
        r = reader.read(this.cbuf, 0, this.length);
        assert (r == this.length);
        return true;
    }

    private static int utf8Bytes(int codePoint) {
        return codePoint <= 127 ? 1 : (codePoint <= 2047 ? 2 : (codePoint <= 65535 ? 3 : 4));
    }

    private void throwMalformed(boolean predicate) throws IOException {
        if (predicate) {
            throw new IOException("Malformed surrogates");
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    public int utf8Length() {
        return this.utf8Length;
    }

    @Override
    public char charAt(int index) {
        this.outOfBounds(index < 0 || index >= this.length);
        return this.cbuf[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int count = end - start;
        this.outOfBounds(start < 0 || end < start || count > this.length);
        return String.valueOf(this.cbuf, start, count);
    }

    @Override
    public String toString() {
        return String.valueOf(this.cbuf, 0, this.length);
    }

    public int maxBuffer() {
        return this.cbuf.length;
    }

    private void outOfBounds(boolean predicate) {
        if (predicate) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static Utf8Buffer size(int maxUtf8Length) {
        assert (maxUtf8Length >= 4);
        return new Utf8Buffer(maxUtf8Length);
    }
}

