/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.processing;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import uk.autores.processing.Config;
import uk.autores.processing.ConfigDef;
import uk.autores.processing.Namer;
import uk.autores.processing.Pkg;
import uk.autores.processing.Resource;

public final class Context {
    private final ProcessingEnvironment env;
    private final JavaFileManager.Location location;
    private final Pkg pkg;
    private final Element annotated;
    private final SortedSet<Resource> resources;
    private final List<Config> config;
    private final Namer namer;

    public Context(ProcessingEnvironment env, JavaFileManager.Location location, Pkg pkg, Element annotated, SortedSet<Resource> resources, List<Config> config, Namer namer) {
        this.env = env;
        this.location = Objects.requireNonNull(location, "location");
        this.pkg = pkg;
        this.annotated = Objects.requireNonNull(annotated, "annotatedElement");
        this.resources = Collections.unmodifiableSortedSet(Objects.requireNonNull(resources, "resources"));
        this.config = Collections.unmodifiableList(Objects.requireNonNull(config, "config"));
        this.namer = Objects.requireNonNull(namer, "namer");
    }

    public Optional<String> option(ConfigDef key) {
        return this.config.stream().filter(o -> key.name().equals(o.key())).map(Config::value).findFirst();
    }

    public void printError(String msg) {
        this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, this.annotated);
    }

    public ProcessingEnvironment env() {
        return this.env;
    }

    public JavaFileManager.Location location() {
        return this.location;
    }

    public Pkg pkg() {
        return this.pkg;
    }

    public Element annotated() {
        return this.annotated;
    }

    public SortedSet<Resource> resources() {
        return this.resources;
    }

    public List<Config> config() {
        return this.config;
    }

    public Namer namer() {
        return this.namer;
    }
}

