/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.processing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Namer {
    private static final Set<String> RESERVED = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null", "_"));

    public static boolean isJavaIdentifier(String s) {
        if ("".equals(s) || RESERVED.contains(s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String nameClass(String src) {
        return Namer.replace(src);
    }

    public String nameStaticField(String src) {
        return Namer.replace(src);
    }

    public String nameMethod(String src) {
        return Namer.replace(src);
    }

    public String simplifyResourceName(String resource) {
        int begin = resource.lastIndexOf(47);
        begin = begin < 0 ? 0 : ++begin;
        int end = resource.lastIndexOf(46);
        if (end < 0) {
            end = resource.length();
        }
        return resource.substring(begin, end);
    }

    private static String replace(String s) {
        int codepoint;
        if (Namer.isJavaIdentifier(s)) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        for (int offset = 0; offset < s.length(); offset += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(offset);
            Namer.add(buf, offset, codepoint);
        }
        return buf.toString();
    }

    private static void add(StringBuilder buf, int offset, int codepoint) {
        if (offset == 0) {
            if (Character.isJavaIdentifierStart(codepoint)) {
                buf.append(Character.toChars(codepoint));
            } else {
                buf.append('_');
            }
            return;
        }
        if (Character.isJavaIdentifierPart(codepoint)) {
            buf.append(Character.toChars(codepoint));
        } else {
            buf.append('_');
        }
    }
}

