/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.processing;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.tools.FileObject;

public final class Resource
implements Comparable<Resource> {
    private final FileObject file;
    private final String path;

    public Resource(FileObject file, String path) {
        this.file = Objects.requireNonNull(file, "file");
        this.path = Objects.requireNonNull(path, "path");
    }

    public InputStream open() throws IOException {
        return this.file.openInputStream();
    }

    public String path() {
        return this.path;
    }

    public String filerPath() {
        return this.path.charAt(0) == '/' ? this.path.substring(1) : this.path;
    }

    @Override
    public int compareTo(Resource o) {
        return this.path.compareTo(o.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != Resource.class) {
            return false;
        }
        Resource other = (Resource)obj;
        return other.path.equals(this.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }
}

