/*
 * Decompiled with CFR 0.152.
 */
package uk.autores.processors;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import uk.autores.ClasspathResource;
import uk.autores.ClasspathResources;
import uk.autores.internal.CharSeq;
import uk.autores.internal.OptionValidation;
import uk.autores.internal.ResPath;
import uk.autores.processing.Config;
import uk.autores.processing.Context;
import uk.autores.processing.Handler;
import uk.autores.processing.Namer;
import uk.autores.processing.Pkg;
import uk.autores.processing.Resource;

public final class ClasspathResourceProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_11;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.of(ClasspathResource.class, ClasspathResources.class).map(Class::getName).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return this.proc(annotations, roundEnv);
    }

    private boolean proc(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean consumed = false;
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                consumed = true;
                Name name = typeElement.getQualifiedName();
                if (CharSeq.equivalent(ClasspathResource.class.getName(), name)) {
                    ClasspathResource cpr = element.getAnnotation(ClasspathResource.class);
                    this.process(cpr, element);
                    continue;
                }
                if (!CharSeq.equivalent(ClasspathResources.class.getName(), name)) continue;
                ClasspathResources cprs = element.getAnnotation(ClasspathResources.class);
                for (ClasspathResource cpr : cprs.value()) {
                    this.process(cpr, element);
                }
            }
        }
        return consumed;
    }

    private void process(ClasspathResource cpr, Element annotated) {
        Context context;
        Handler handler;
        try {
            handler = (Handler)this.instance(cpr::handler);
            context = this.ctxt(cpr, annotated);
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString(), annotated);
            return;
        }
        if (!OptionValidation.areValid(handler, context)) {
            return;
        }
        try {
            handler.handle(context);
        }
        catch (Exception e) {
            Object msg = "ERROR:";
            msg = (String)msg + " Location: " + context.location();
            msg = (String)msg + " Package:" + context.pkg().name();
            msg = (String)msg + " Exception: " + e;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, (CharSequence)msg, annotated);
        }
    }

    private SortedSet<Resource> resources(ClasspathResource cpr, Pkg pkg, Element annotated) {
        TreeSet<Resource> map = new TreeSet<Resource>();
        String value = "";
        try {
            Filer filer = this.processingEnv.getFiler();
            for (String resource : cpr.value()) {
                String filerPath = ResPath.massage(this.processingEnv, annotated, pkg, resource);
                if (filerPath == null) continue;
                value = filerPath;
                FileObject fo = filer.getResource(cpr.location(), pkg.resourcePackage(), value);
                try (InputStream is = fo.openInputStream();){
                    assert (is != null);
                }
                map.add(new Resource(fo, resource));
            }
        }
        catch (Exception e) {
            Object msg = "ERROR:";
            msg = (String)msg + " Location: " + cpr.location();
            msg = (String)msg + " Resource: " + value;
            msg = (String)msg + " Exception: " + e;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, (CharSequence)msg, annotated);
            return Collections.emptySortedSet();
        }
        return map;
    }

    private Context ctxt(ClasspathResource cpr, Element annotated) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Namer namer = (Namer)this.instance(cpr::namer);
        ArrayList<Config> options = new ArrayList<Config>();
        for (ClasspathResource.Cfg option : cpr.config()) {
            options.add(new Config(option.key(), option.value()));
        }
        Pkg pkg = this.pkg(cpr.relative(), annotated);
        SortedSet<Resource> resources = this.resources(cpr, pkg, annotated);
        return new Context(this.processingEnv, cpr.location(), this.pkg(cpr.relative(), annotated), annotated, resources, options, namer);
    }

    private <T> T instance(Supplier<Class<T>> s) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        TypeMirror mirror = this.mirror(s);
        String className = mirror.toString();
        Class<?> c = this.getClass().getClassLoader().loadClass(className);
        return (T)c.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private TypeMirror mirror(Supplier<?> s) {
        try {
            s.get();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        throw new AssertionError();
    }

    private Pkg pkg(boolean relative, Element annotated) {
        String qualified = this.processingEnv.getElementUtils().getPackageOf(annotated).getQualifiedName().toString();
        return new Pkg(qualified, relative);
    }
}

