/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jpawlak.maptoobjectconverter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.reflect.ReflectionFactory;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class MapToObjectConverter {
    private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();

    public <T> T convert(Map<String, Object> map, Class<T> targetClass) {
        MapToObjectConverter.checkParameters(map, targetClass);
        MapToObjectConverter.checkKeysEqualToFieldsNames(map.keySet(), targetClass);
        MapToObjectConverter.checkOptionalFieldsForNullValues(map, targetClass);
        T result = MapToObjectConverter.createInstance(targetClass);
        MapToObjectConverter.setFields(map, targetClass, result);
        return result;
    }

    private static void checkParameters(Map<?, ?> map, Class<?> targetClass) {
        if (map == null) {
            throw MapToObjectConverter.exception("Map cannot be null", new Object[0]);
        }
        if (targetClass == null) {
            throw MapToObjectConverter.exception("Target class cannot be null", new Object[0]);
        }
        if (targetClass.isPrimitive()) {
            throw MapToObjectConverter.exception("Cannot convert map to primitive type. Use boxed primitive instead", new Object[0]);
        }
        if (targetClass.isEnum()) {
            throw MapToObjectConverter.exception("Cannot convert map to enum", new Object[0]);
        }
        if (targetClass.isAnnotation()) {
            throw MapToObjectConverter.exception("Cannot convert map to annotation", new Object[0]);
        }
        if (targetClass.isInterface()) {
            throw MapToObjectConverter.exception("Cannot convert map to interface", new Object[0]);
        }
        if ((targetClass.getModifiers() & 0x400) != 0) {
            throw MapToObjectConverter.exception("Cannot convert map to abstract class", new Object[0]);
        }
    }

    private static void checkKeysEqualToFieldsNames(Set<String> keys, Class<?> targetClass) {
        Set fieldsNames = MapToObjectConverter.fieldsOf(targetClass).map(Field::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        Set missingFields = keys.stream().filter(key -> !fieldsNames.contains(key)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!missingFields.isEmpty()) {
            throw MapToObjectConverter.exception("No fields for keys: '%s'", missingFields.stream().collect(Collectors.joining("', '")));
        }
        Set missingValues = fieldsNames.stream().filter(fieldName -> !keys.contains(fieldName)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!missingValues.isEmpty()) {
            throw MapToObjectConverter.exception("No values for fields: '%s'", missingValues.stream().collect(Collectors.joining("', '")));
        }
    }

    private static void checkOptionalFieldsForNullValues(Map<String, Object> map, Class<?> targetClass) {
        Set fieldsNames = MapToObjectConverter.fieldsOf(targetClass).filter(field -> field.getType() != Optional.class && map.get(field.getName()) == null).map(Field::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!fieldsNames.isEmpty()) {
            throw MapToObjectConverter.exception("Null values require fields to be Optional. Null values for fields: '%s'", fieldsNames.stream().collect(Collectors.joining("', '")));
        }
    }

    private static <T> T createInstance(Class<T> targetClass) {
        try {
            Constructor objectNoArgConstructor = Object.class.getDeclaredConstructor(new Class[0]);
            Constructor<?> constructor = REFLECTION_FACTORY.newConstructorForSerialization(targetClass, objectNoArgConstructor);
            return targetClass.cast(constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> void setFields(Map<String, Object> map, Class<T> targetClass, T result) {
        MapToObjectConverter.fieldsOf(targetClass).forEach(field -> {
            if (field.getType() == Optional.class) {
                MapToObjectConverter.setOptionalField(result, field, map.get(field.getName()));
            } else if (field.getType().isEnum()) {
                MapToObjectConverter.setField(result, field, MapToObjectConverter.asEnum(field.getType(), map.get(field.getName())));
            } else {
                MapToObjectConverter.setField(result, field, map.get(field.getName()));
            }
        });
    }

    private static void setOptionalField(Object object, Field field, Object value) {
        if (value == null) {
            MapToObjectConverter.setField(object, field, Optional.empty());
        } else {
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedTypeImpl)) {
                throw MapToObjectConverter.exception("Raw types are not supported. Field '%s' is 'Optional'", field.getName());
            }
            Type parameterType = ((ParameterizedTypeImpl)genericType).getActualTypeArguments()[0];
            if (!(parameterType instanceof Class)) {
                throw MapToObjectConverter.exception("Wildcards are not supported. Field '%s' is 'Optional<%s>'", field.getName(), parameterType);
            }
            if (((Class)parameterType).isEnum()) {
                MapToObjectConverter.setField(object, field, Optional.of(MapToObjectConverter.asEnum((Class)parameterType, value)));
                return;
            }
            if (value.getClass() != parameterType) {
                throw MapToObjectConverter.exception("Cannot assign value of type 'Optional<%s>' to field '%s' of type 'Optional<%s>'", value.getClass().getName(), field.getName(), parameterType.getTypeName());
            }
            MapToObjectConverter.setField(object, field, Optional.of(value));
        }
    }

    private static void setField(Object object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw MapToObjectConverter.exception("Cannot assign value of type '%s' to field '%s' of type '%s'", value.getClass().getName(), field.getName(), field.getType().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<Field> fieldsOf(Class<?> targetClass) {
        Stream<Field> fields = Stream.empty();
        while (targetClass != Object.class) {
            fields = Stream.concat(fields, Arrays.stream(targetClass.getDeclaredFields()));
            targetClass = targetClass.getSuperclass();
        }
        return fields.filter(field -> (field.getModifiers() & 8) == 0).filter(field -> !field.isSynthetic());
    }

    private static <E> E asEnum(Class<E> enumClass, Object value) {
        try {
            return (E)enumClass.getDeclaredMethod("valueOf", String.class).invoke(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof IllegalArgumentException) {
                throw MapToObjectConverter.exception("'%s' does not have an enum named '%s'", enumClass.getName(), value);
            }
            if (e instanceof IllegalArgumentException) {
                throw MapToObjectConverter.exception("Cannot convert value of type '%s' to enum", value.getClass().getName());
            }
            throw new RuntimeException(e);
        }
    }

    private static IllegalArgumentException exception(String message, Object ... args) {
        return new IllegalArgumentException(String.format(message, args));
    }
}

