/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.csv.validator.api.java;

import cats.data.NonEmptyList;
import cats.data.Validated;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import uk.gov.nationalarchives.csv.validator.ErrorType;
import uk.gov.nationalarchives.csv.validator.MetaDataValidator;
import uk.gov.nationalarchives.csv.validator.SchemaDefinitionError$;
import uk.gov.nationalarchives.csv.validator.Util$;
import uk.gov.nationalarchives.csv.validator.ValidationError$;
import uk.gov.nationalarchives.csv.validator.ValidationWarning$;
import uk.gov.nationalarchives.csv.validator.api.CsvValidator;
import uk.gov.nationalarchives.csv.validator.api.CsvValidator$;
import uk.gov.nationalarchives.csv.validator.api.TextFile;
import uk.gov.nationalarchives.csv.validator.api.java.ErrorMessage;
import uk.gov.nationalarchives.csv.validator.api.java.FailMessage;
import uk.gov.nationalarchives.csv.validator.api.java.ProgressCallback;
import uk.gov.nationalarchives.csv.validator.api.java.Substitution;
import uk.gov.nationalarchives.csv.validator.api.java.WarningMessage;
import uk.gov.nationalarchives.csv.validator.schema.Schema;

public final class CsvValidatorJavaBridge$ {
    public static final CsvValidatorJavaBridge$ MODULE$ = new CsvValidatorJavaBridge$();

    public java.util.List<FailMessage> validate(String csvFile, Charset csvEncoding, String csvSchemaFile, Charset csvSchemaEncoding, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace) {
        return this.validate(csvFile, csvEncoding, true, csvSchemaFile, csvSchemaEncoding, false, failFast, pathSubstitutionsList, enforceCaseSensitivePathChecks, trace, (Option<uk.gov.nationalarchives.csv.validator.ProgressCallback>)None$.MODULE$);
    }

    public java.util.List<FailMessage> validate(String csvFile, Charset csvEncoding, String csvSchemaFile, Charset csvSchemaEncoding, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace, ProgressCallback progress) {
        uk.gov.nationalarchives.csv.validator.ProgressCallback sProgressCallback = new uk.gov.nationalarchives.csv.validator.ProgressCallback(progress){
            private final ProgressCallback progress$1;

            public void update(int total, int processed) {
                uk.gov.nationalarchives.csv.validator.ProgressCallback.update$((uk.gov.nationalarchives.csv.validator.ProgressCallback)this, (int)total, (int)processed);
            }

            public void update(float complete) {
                this.progress$1.update(complete);
            }
            {
                this.progress$1 = progress$1;
                uk.gov.nationalarchives.csv.validator.ProgressCallback.$init$((uk.gov.nationalarchives.csv.validator.ProgressCallback)this);
            }
        };
        return this.validate(csvFile, csvEncoding, true, csvSchemaFile, csvSchemaEncoding, false, failFast, pathSubstitutionsList, enforceCaseSensitivePathChecks, trace, (Option<uk.gov.nationalarchives.csv.validator.ProgressCallback>)new Some((Object)sProgressCallback));
    }

    public java.util.List<FailMessage> validate(String csvFile, Charset csvEncoding, boolean validateCsvEncoding, String csvSchemaFile, Charset csvSchemaEncoding, boolean validateCsvSchemaEncoding, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace) {
        return this.validate(csvFile, csvEncoding, validateCsvEncoding, csvSchemaFile, csvSchemaEncoding, validateCsvSchemaEncoding, failFast, pathSubstitutionsList, enforceCaseSensitivePathChecks, trace, (Option<uk.gov.nationalarchives.csv.validator.ProgressCallback>)None$.MODULE$);
    }

    public java.util.List<FailMessage> validate(String csvFile, Charset csvEncoding, boolean validateCsvEncoding, String csvSchemaFile, Charset csvSchemaEncoding, boolean validateCsvSchemaEncoding, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace, ProgressCallback progress) {
        uk.gov.nationalarchives.csv.validator.ProgressCallback sProgressCallback = new uk.gov.nationalarchives.csv.validator.ProgressCallback(progress){
            private final ProgressCallback progress$2;

            public void update(int total, int processed) {
                uk.gov.nationalarchives.csv.validator.ProgressCallback.update$((uk.gov.nationalarchives.csv.validator.ProgressCallback)this, (int)total, (int)processed);
            }

            public void update(float complete) {
                this.progress$2.update(complete);
            }
            {
                this.progress$2 = progress$2;
                uk.gov.nationalarchives.csv.validator.ProgressCallback.$init$((uk.gov.nationalarchives.csv.validator.ProgressCallback)this);
            }
        };
        return this.validate(csvFile, csvEncoding, validateCsvEncoding, csvSchemaFile, csvSchemaEncoding, validateCsvSchemaEncoding, failFast, pathSubstitutionsList, enforceCaseSensitivePathChecks, trace, (Option<uk.gov.nationalarchives.csv.validator.ProgressCallback>)new Some((Object)sProgressCallback));
    }

    private java.util.List<FailMessage> validate(String csvFile, Charset csvEncoding, boolean validateCsvEncoding, String csvSchemaFile, Charset csvSchemaEncoding, boolean validateCsvSchemaEncoding, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace, Option<uk.gov.nationalarchives.csv.validator.ProgressCallback> progress) {
        List pathSubs = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(pathSubstitutionsList).asScala().map((Function1 & Serializable)x -> new Tuple2((Object)x.getFrom(), (Object)x.getTo()))).toList();
        TextFile csvTextFile = new TextFile(Paths.get(csvFile, new String[0]), csvEncoding, validateCsvEncoding);
        TextFile csvSchemaTextFile = new TextFile(Paths.get(csvSchemaFile, new String[0]), csvSchemaEncoding, validateCsvSchemaEncoding);
        Path path = csvTextFile.file();
        Path path2 = csvSchemaTextFile.file();
        Validated validated = Util$.MODULE$.checkFilesReadable(Nil$.MODULE$.$colon$colon((Object)path2).$colon$colon((Object)path));
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            NonEmptyList errors = (NonEmptyList)invalid.e();
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)errors.map((Function1 & Serializable)x$1 -> MODULE$.asJavaMessage((uk.gov.nationalarchives.csv.validator.FailMessage)x$1)).toList()).asJava();
        }
        if (validated instanceof Validated.Valid) {
            CsvValidator validator = CsvValidator$.MODULE$.createValidator(failFast, pathSubs, enforceCaseSensitivePathChecks, trace);
            Validated validated2 = validator.parseSchema(csvSchemaTextFile);
            if (validated2 instanceof Validated.Invalid) {
                Validated.Invalid invalid = (Validated.Invalid)validated2;
                NonEmptyList errors = (NonEmptyList)invalid.e();
                return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)errors.map((Function1 & Serializable)x$2 -> MODULE$.asJavaMessage((uk.gov.nationalarchives.csv.validator.FailMessage)x$2)).toList()).asJava();
            }
            if (validated2 instanceof Validated.Valid) {
                Validated.Valid valid = (Validated.Valid)validated2;
                Schema schema = (Schema)valid.a();
                Validated validated3 = validator.validate(csvTextFile, schema, progress);
                if (validated3 instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)validated3;
                    NonEmptyList errors = (NonEmptyList)invalid.e();
                    return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)errors.map((Function1 & Serializable)x$3 -> MODULE$.asJavaMessage((uk.gov.nationalarchives.csv.validator.FailMessage)x$3)).toList()).asJava();
                }
                if (validated3 instanceof Validated.Valid) {
                    return new ArrayList<FailMessage>();
                }
                throw new MatchError((Object)validated3);
            }
            throw new MatchError((Object)validated2);
        }
        throw new MatchError((Object)validated);
    }

    public java.util.List<FailMessage> validate(Reader csvData, Reader csvSchema, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace) {
        return this.validate(csvData, csvSchema, failFast, pathSubstitutionsList, enforceCaseSensitivePathChecks, trace, (Option<uk.gov.nationalarchives.csv.validator.ProgressCallback>)None$.MODULE$);
    }

    public java.util.List<FailMessage> validate(Reader csvData, Reader csvSchema, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace, ProgressCallback progress) {
        uk.gov.nationalarchives.csv.validator.ProgressCallback sProgressCallback = new uk.gov.nationalarchives.csv.validator.ProgressCallback(progress){
            private final ProgressCallback progress$3;

            public void update(int total, int processed) {
                uk.gov.nationalarchives.csv.validator.ProgressCallback.update$((uk.gov.nationalarchives.csv.validator.ProgressCallback)this, (int)total, (int)processed);
            }

            public void update(float complete) {
                this.progress$3.update(complete);
            }
            {
                this.progress$3 = progress$3;
                uk.gov.nationalarchives.csv.validator.ProgressCallback.$init$((uk.gov.nationalarchives.csv.validator.ProgressCallback)this);
            }
        };
        return this.validate(csvData, csvSchema, failFast, pathSubstitutionsList, enforceCaseSensitivePathChecks, trace, (Option<uk.gov.nationalarchives.csv.validator.ProgressCallback>)new Some((Object)sProgressCallback));
    }

    private java.util.List<FailMessage> validate(Reader csvData, Reader csvSchema, boolean failFast, java.util.List<Substitution> pathSubstitutionsList, boolean enforceCaseSensitivePathChecks, boolean trace, Option<uk.gov.nationalarchives.csv.validator.ProgressCallback> progress) {
        List pathSubs = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(pathSubstitutionsList).asScala().map((Function1 & Serializable)x -> new Tuple2((Object)x.getFrom(), (Object)x.getTo()))).toList();
        CsvValidator validator = CsvValidator$.MODULE$.createValidator(failFast, pathSubs, enforceCaseSensitivePathChecks, trace);
        Validated validated = validator.parseSchema(csvSchema);
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            NonEmptyList errors = (NonEmptyList)invalid.e();
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)errors.map((Function1 & Serializable)x$4 -> MODULE$.asJavaMessage((uk.gov.nationalarchives.csv.validator.FailMessage)x$4)).toList()).asJava();
        }
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Schema schema = (Schema)valid.a();
            Validated validated2 = ((MetaDataValidator)validator).validate(csvData, schema, progress);
            if (validated2 instanceof Validated.Invalid) {
                Validated.Invalid invalid = (Validated.Invalid)validated2;
                NonEmptyList errors = (NonEmptyList)invalid.e();
                return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)errors.map((Function1 & Serializable)x$5 -> MODULE$.asJavaMessage((uk.gov.nationalarchives.csv.validator.FailMessage)x$5)).toList()).asJava();
            }
            if (validated2 instanceof Validated.Valid) {
                return new ArrayList<FailMessage>();
            }
            throw new MatchError((Object)validated2);
        }
        throw new MatchError((Object)validated);
    }

    private FailMessage asJavaMessage(uk.gov.nationalarchives.csv.validator.FailMessage f) {
        uk.gov.nationalarchives.csv.validator.FailMessage failMessage = f;
        if (failMessage != null) {
            ErrorType errorType = failMessage.type();
            String msg = failMessage.message();
            Option lineNr = failMessage.lineNumber();
            Option columnIdx = failMessage.columnIndex();
            if (ValidationWarning$.MODULE$.equals(errorType)) {
                return new WarningMessage(msg, BoxesRunTime.unboxToInt((Object)lineNr.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), BoxesRunTime.unboxToInt((Object)columnIdx.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)));
            }
        }
        if (failMessage != null) {
            ErrorType errorType = failMessage.type();
            String msg = failMessage.message();
            Option lineNr = failMessage.lineNumber();
            Option columnIdx = failMessage.columnIndex();
            if (ValidationError$.MODULE$.equals(errorType)) {
                return new ErrorMessage(msg, BoxesRunTime.unboxToInt((Object)lineNr.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), BoxesRunTime.unboxToInt((Object)columnIdx.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)));
            }
        }
        if (failMessage != null) {
            ErrorType errorType = failMessage.type();
            String msg = failMessage.message();
            Option lineNr = failMessage.lineNumber();
            Option columnIdx = failMessage.columnIndex();
            if (SchemaDefinitionError$.MODULE$.equals(errorType)) {
                return new ErrorMessage(msg, BoxesRunTime.unboxToInt((Object)lineNr.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), BoxesRunTime.unboxToInt((Object)columnIdx.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)));
            }
        }
        throw new MatchError((Object)failMessage);
    }

    private CsvValidatorJavaBridge$() {
    }
}

