/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.UnmappableCharacterException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.AdiWriter;
import org.marsik.ham.adif.Adif3;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.AdifHeader;
import org.marsik.ham.adif.enums.AntPath;
import org.marsik.ham.adif.enums.Band;
import org.marsik.ham.adif.enums.Continent;
import org.marsik.ham.adif.enums.Mode;
import org.marsik.ham.adif.enums.Propagation;
import org.marsik.ham.adif.enums.QslRcvd;
import org.marsik.ham.adif.enums.QslSent;
import org.marsik.ham.adif.enums.QslVia;
import org.marsik.ham.adif.enums.QsoComplete;
import org.marsik.ham.adif.enums.QsoUploadStatus;
import org.marsik.ham.adif.enums.Submode;
import org.marsik.ham.adif.types.Iota;
import org.marsik.ham.adif.types.Sota;
import org.marsik.ham.grid.CoordinateWriter;
import org.marsik.ham.util.MultiOptional;

public class AdiReader {
    private static final Pattern NUMERIC_RE = Pattern.compile("-?\\d+(\\.\\d+)?");
    private boolean quirksMode = false;
    private String current;

    public boolean isQuirksMode() {
        return this.quirksMode;
    }

    public void setQuirksMode(boolean quirksMode) {
        this.quirksMode = quirksMode;
    }

    public Optional<Adif3> read(BufferedReader reader) throws IOException {
        Adif3 document = new Adif3();
        reader.mark(1);
        int c = reader.read();
        if (c == -1) {
            return Optional.empty();
        }
        if (c != 60) {
            AdifHeader header = this.readHeader(reader);
            document.setHeader(header);
        } else {
            reader.reset();
        }
        int recordCount = 1;
        try {
            Map<String, String> recordFields;
            while ((recordFields = this.readRecord(reader)) != null) {
                document.getRecords().add(this.parseRecord(recordFields));
                ++recordCount;
            }
        }
        catch (UnmappableCharacterException e) {
            System.err.println(String.format("Caught unmappable character exception reading record number : %d, field: %s", recordCount, this.current));
            throw e;
        }
        return Optional.of(document);
    }

    private Adif3Record parseRecord(Map<String, String> recordFields) {
        Adif3Record record = new Adif3Record();
        this.maybeGet(recordFields, "ADDRESS").map(Function.identity()).ifPresent(record::setAddress);
        this.maybeGet(recordFields, "AGE").map(Integer::parseInt).ifPresent(record::setAge);
        this.maybeGet(recordFields, "A_INDEX").map(Double::parseDouble).ifPresent(record::setAIndex);
        this.maybeGet(recordFields, "ANT_AZ").map(Double::parseDouble).ifPresent(record::setAntAz);
        this.maybeGet(recordFields, "ANT_EL").map(Double::parseDouble).ifPresent(record::setAntEl);
        this.maybeGet(recordFields, "ANT_PATH").map(AntPath::findByCode).ifPresent(record::setAntPath);
        this.maybeGet(recordFields, "ARRL_SECT").map(Function.identity()).ifPresent(record::setArrlSect);
        this.maybeGet(recordFields, "AWARD_SUBMITTED").map(s -> this.parseCommaArray((String)s, String::valueOf)).ifPresent(record::setAwardSubmitted);
        this.maybeGet(recordFields, "AWARD_GRANTED").map(s -> this.parseCommaArray((String)s, String::valueOf)).ifPresent(record::setAwardGranted);
        this.maybeGet(recordFields, "BAND").map(Band::findByCode).ifPresent(record::setBand);
        this.maybeGet(recordFields, "BAND_RX").map(Band::findByCode).ifPresent(record::setBandRx);
        this.maybeGet(recordFields, "CALL").map(Function.identity()).ifPresent(record::setCall);
        this.maybeGet(recordFields, "CHECK").map(Function.identity()).ifPresent(record::setCheck);
        this.maybeGet(recordFields, "CLASS").map(Function.identity()).ifPresent(record::setContestClass);
        this.maybeGet(recordFields, "CLUBLOG_QSO_UPLOAD_DATE").map(this::parseDate).ifPresent(record::setClublogQsoUploadDate);
        this.maybeGet(recordFields, "CLUBLOG_QSO_UPLOAD_STATUS").map(QsoUploadStatus::findByCode).ifPresent(record::setClublogQsoUploadStatus);
        this.maybeGet(recordFields, "CNTY").map(Function.identity()).ifPresent(record::setCnty);
        this.maybeGet(recordFields, "COMMENT").map(Function.identity()).ifPresent(record::setComment);
        this.maybeGet(recordFields, "CONT").map(Continent::findByCode).ifPresent(record::setCont);
        this.maybeGet(recordFields, "CONTACTED_OP").map(Function.identity()).ifPresent(record::setContactedOp);
        this.maybeGet(recordFields, "CONTEST_ID").map(Function.identity()).ifPresent(record::setContestId);
        this.maybeGet(recordFields, "COUNTRY").map(Function.identity()).ifPresent(record::setCountry);
        this.maybeGet(recordFields, "CQZ").map(Integer::parseInt).ifPresent(record::setCqz);
        this.maybeGet(recordFields, "CREDIT_SUBMITTED").map(s -> this.parseCommaArray((String)s, String::valueOf)).ifPresent(record::setCreditSubmitted);
        this.maybeGet(recordFields, "CREDIT_GRANTED").map(s -> this.parseCommaArray((String)s, String::valueOf)).ifPresent(record::setCreditGranted);
        this.maybeGet(recordFields, "DARC_DOK").map(Function.identity()).ifPresent(record::setDarcDok);
        this.maybeGet(recordFields, "DISTANCE").map(Double::parseDouble).ifPresent(record::setDistance);
        this.maybeGet(recordFields, "DXCC").map(Integer::parseInt).ifPresent(record::setDxcc);
        this.maybeGet(recordFields, "EMAIL").map(Function.identity()).ifPresent(record::setEmail);
        this.maybeGet(recordFields, "EQ_CALL").map(Function.identity()).ifPresent(record::setEqCall);
        this.maybeGet(recordFields, "EQSL_QSLRDATE").map(this::parseDate).ifPresent(record::setEqslQslRDate);
        this.maybeGet(recordFields, "EQSL_QSLSDATE").map(this::parseDate).ifPresent(record::setEqslQslSDate);
        this.maybeGet(recordFields, "EQSL_QSL_RCVD").map(QslRcvd::findByCode).ifPresent(record::setEqslQslRcvd);
        this.maybeGet(recordFields, "EQSL_QSL_SENT").map(QslSent::findByCode).ifPresent(record::setEqslQslSent);
        this.maybeGet(recordFields, "FISTS").map(Function.identity()).ifPresent(record::setFists);
        this.maybeGet(recordFields, "FISTS_CC").map(Function.identity()).ifPresent(record::setFistsCc);
        this.maybeGet(recordFields, "FORCE_INT").map(this::parseBool).ifPresent(record::setForceInt);
        this.maybeGet(recordFields, "FREQ").map(Double::parseDouble).ifPresent(record::setFreq);
        this.maybeGet(recordFields, "FREQ_RX").map(Double::parseDouble).ifPresent(record::setFreqRx);
        this.maybeGet(recordFields, "GRIDSQUARE").map(Function.identity()).ifPresent(record::setGridsquare);
        this.maybeGet(recordFields, "HRDLOG_QSO_UPLOAD_DATE").map(this::parseDate).ifPresent(record::setHrdlogQsoUploadDate);
        this.maybeGet(recordFields, "HRDLOG_QSO_UPLOAD_STATUS").map(QsoUploadStatus::findByCode).ifPresent(record::setHrdlogQsoUploadStatus);
        this.maybeGet(recordFields, "IOTA").map(Iota::findByCode).ifPresent(record::setIota);
        this.maybeGet(recordFields, "IOTA_ISLAND_ID").map(Function.identity()).ifPresent(record::setIotaIslandId);
        this.maybeGet(recordFields, "ITUZ").map(Integer::parseInt).ifPresent(record::setItuz);
        this.maybeGet(recordFields, "K_INDEX").map(Double::parseDouble).ifPresent(record::setKIndex);
        Optional<Double> lat = this.maybeGet(recordFields, "LAT").map(CoordinateWriter::dmToLat);
        Optional<Double> lon = this.maybeGet(recordFields, "LON").map(CoordinateWriter::dmToLon);
        MultiOptional.two(lat, lon, GlobalCoordinates::new).ifPresent(record::setCoordinates);
        this.maybeGet(recordFields, "LOTW_QSLRDATE").map(this::parseDate).ifPresent(record::setLotwQslRDate);
        this.maybeGet(recordFields, "LOTW_QSLSDATE").map(this::parseDate).ifPresent(record::setLotwQslSDate);
        this.maybeGet(recordFields, "LOTW_QSL_RCVD").map(QslRcvd::findByCode).ifPresent(record::setLotwQslRcvd);
        this.maybeGet(recordFields, "LOTW_QSL_SENT").map(QslSent::findByCode).ifPresent(record::setLotwQslSent);
        this.maybeGet(recordFields, "MAX_BURSTS").map(Integer::parseInt).ifPresent(record::setMaxBursts);
        try {
            this.maybeGet(recordFields, "MODE").map(Mode::findByCode).ifPresent(record::setMode);
        }
        catch (IllegalArgumentException e) {
            if (this.quirksMode) {
                this.maybeGet(recordFields, "MODE").map(Submode::findByCode).ifPresent(sm -> record.setMode(sm.getMode()));
            }
            throw e;
        }
        this.maybeGet(recordFields, "MS_SHOWER").map(Function.identity()).ifPresent(record::setMsShower);
        this.maybeGet(recordFields, "MY_ANTENNA").map(Function.identity()).ifPresent(record::setMyAntenna);
        this.maybeGet(recordFields, "MY_CITY").map(Function.identity()).ifPresent(record::setMyCity);
        this.maybeGet(recordFields, "MY_CNTY").map(Function.identity()).ifPresent(record::setMyCnty);
        this.maybeGet(recordFields, "MY_COUNTRY").map(Function.identity()).ifPresent(record::setMyCountry);
        this.maybeGet(recordFields, "MY_CQ_ZONE").map(Integer::parseInt).ifPresent(record::setMyCqZone);
        this.maybeGet(recordFields, "MY_DXCC").map(Integer::parseInt).ifPresent(record::setMyDxcc);
        this.maybeGet(recordFields, "MY_FISTS").map(Function.identity()).ifPresent(record::setMyFists);
        this.maybeGet(recordFields, "MY_GRIDSQUARE").map(Function.identity()).ifPresent(record::setMyGridSquare);
        this.maybeGet(recordFields, "MY_IOTA").map(Iota::findByCode).ifPresent(record::setMyIota);
        this.maybeGet(recordFields, "MY_IOTA_ISLAND_ID").map(Function.identity()).ifPresent(record::setMyIotaIslandId);
        this.maybeGet(recordFields, "MY_ITU_ZONE").map(Integer::parseInt).ifPresent(record::setMyItuZone);
        Optional<Double> myLat = this.maybeGet(recordFields, "MY_LAT").map(CoordinateWriter::dmToLat);
        Optional<Double> myLon = this.maybeGet(recordFields, "MY_LON").map(CoordinateWriter::dmToLon);
        MultiOptional.two(myLat, myLon, GlobalCoordinates::new).ifPresent(record::setMyCoordinates);
        this.maybeGet(recordFields, "MY_NAME").map(Function.identity()).ifPresent(record::setMyName);
        this.maybeGet(recordFields, "MY_POSTAL_CODE").map(Function.identity()).ifPresent(record::setMyPostalCode);
        this.maybeGet(recordFields, "MY_RIG").map(Function.identity()).ifPresent(record::setMyRig);
        this.maybeGet(recordFields, "MY_SIG").map(Function.identity()).ifPresent(record::setMySig);
        this.maybeGet(recordFields, "MY_SIG_INFO").map(Function.identity()).ifPresent(record::setMySigInfo);
        this.maybeGet(recordFields, "MY_SOTA_REF").map(Sota::valueOf).ifPresent(record::setMySotaRef);
        this.maybeGet(recordFields, "MY_STATE").map(Function.identity()).ifPresent(record::setMyState);
        this.maybeGet(recordFields, "MY_STREET").map(Function.identity()).ifPresent(record::setMyStreet);
        this.maybeGet(recordFields, "MY_USACA_COUNTIES").map(s -> this.parseColonArray((String)s, String::valueOf)).ifPresent(record::setMyUsaCaCounties);
        this.maybeGet(recordFields, "MY_VUCC_GRIDS").map(s -> this.parseCommaArray((String)s, String::valueOf)).ifPresent(record::setMyVuccGrids);
        this.maybeGet(recordFields, "NAME").map(Function.identity()).ifPresent(record::setName);
        this.maybeGet(recordFields, "NOTES").map(Function.identity()).ifPresent(record::setNotes);
        this.maybeGet(recordFields, "NR_BURSTS").map(Integer::parseInt).ifPresent(record::setNrBursts);
        this.maybeGet(recordFields, "NR_PINGS").map(Integer::parseInt).ifPresent(record::setNrPings);
        this.maybeGet(recordFields, "OPERATOR").map(Function.identity()).ifPresent(record::setOperator);
        this.maybeGet(recordFields, "OWNER_CALLSIGN").map(Function.identity()).ifPresent(record::setOwnerCallsign);
        this.maybeGet(recordFields, "PFX").map(Function.identity()).ifPresent(record::setPfx);
        this.maybeGet(recordFields, "PRECEDENCE").map(Function.identity()).ifPresent(record::setPrecedence);
        this.maybeGet(recordFields, "PROP_MODE").map(Propagation::findByCode).ifPresent(record::setPropMode);
        this.maybeGet(recordFields, "PUBLIC_KEY").map(Function.identity()).ifPresent(record::setPublicKey);
        this.maybeGet(recordFields, "QRZCOM_QSO_UPLOAD_DATE").map(this::parseDate).ifPresent(record::setQrzcomQsoUploadDate);
        this.maybeGet(recordFields, "QRZCOM_QSO_UPLOAD_STATUS").map(QsoUploadStatus::findByCode).ifPresent(record::setQrzcomQsoUploadStatus);
        this.maybeGet(recordFields, "QSLMSG").map(Function.identity()).ifPresent(record::setQslMsg);
        this.maybeGet(recordFields, "QSLRDATE").map(this::parseLocalDate).ifPresent(record::setQslRDate);
        this.maybeGet(recordFields, "QSLSDATE").map(this::parseLocalDate).ifPresent(record::setQslSDate);
        this.maybeGet(recordFields, "QSL_RCVD").map(QslRcvd::findByCode).ifPresent(record::setQslRcvd);
        this.maybeGet(recordFields, "QSL_RCVD_VIA").map(QslVia::findByCode).ifPresent(record::setQslRcvdVia);
        this.maybeGet(recordFields, "QSL_SENT").map(QslSent::findByCode).ifPresent(record::setQslSent);
        this.maybeGet(recordFields, "QSL_SENT_VIA").map(QslVia::findByCode).ifPresent(record::setQslSentVia);
        this.maybeGet(recordFields, "QSL_VIA").map(Function.identity()).ifPresent(record::setQslVia);
        this.maybeGet(recordFields, "QSO_COMPLETE").map(QsoComplete::findByCode).ifPresent(record::setQsoComplete);
        this.maybeGet(recordFields, "QSO_DATE").map(s -> LocalDate.parse(s, AdiWriter.dateFormatter)).ifPresent(record::setQsoDate);
        this.maybeGet(recordFields, "QSO_DATE_OFF").map(s -> LocalDate.parse(s, AdiWriter.dateFormatter)).ifPresent(record::setQsoDateOff);
        this.maybeGet(recordFields, "QSO_RANDOM").map(this::parseBool).ifPresent(record::setQsoRandom);
        this.maybeGet(recordFields, "QTH").map(Function.identity()).ifPresent(record::setQth);
        this.maybeGet(recordFields, "REGION").map(Function.identity()).ifPresent(record::setRegion);
        this.maybeGet(recordFields, "RIG").map(Function.identity()).ifPresent(record::setRig);
        this.maybeGet(recordFields, "RST_RCVD").map(Function.identity()).ifPresent(record::setRstRcvd);
        this.maybeGet(recordFields, "RST_SENT").map(Function.identity()).ifPresent(record::setRstSent);
        this.maybeGet(recordFields, "RX_PWR").map(s -> s.replaceAll("[wW]$", "")).filter(AdiReader::isNumeric).map(Double::parseDouble).ifPresent(record::setRxPwr);
        this.maybeGet(recordFields, "SAT_MODE").map(Function.identity()).ifPresent(record::setSatMode);
        this.maybeGet(recordFields, "SAT_NAME").map(Function.identity()).ifPresent(record::setSatName);
        this.maybeGet(recordFields, "SFI").map(Double::parseDouble).ifPresent(record::setSfi);
        this.maybeGet(recordFields, "SIG").map(Function.identity()).ifPresent(record::setSig);
        this.maybeGet(recordFields, "SIG_INFO").map(Function.identity()).ifPresent(record::setSigInfo);
        this.maybeGet(recordFields, "SILENT_KEY").map(this::parseBool).ifPresent(record::setSilentKey);
        this.maybeGet(recordFields, "SKCC").map(Function.identity()).ifPresent(record::setSkcc);
        this.maybeGet(recordFields, "SOTA_REF").map(Sota::valueOf).ifPresent(record::setSotaRef);
        this.maybeGet(recordFields, "SRX").map(Integer::parseInt).ifPresent(record::setSrx);
        this.maybeGet(recordFields, "SRX_STRING").map(Function.identity()).ifPresent(record::setSrxString);
        this.maybeGet(recordFields, "STATE").map(Function.identity()).ifPresent(record::setState);
        this.maybeGet(recordFields, "STATION_CALLSIGN").map(Function.identity()).ifPresent(record::setStationCallsign);
        this.maybeGet(recordFields, "STX").map(Integer::parseInt).ifPresent(record::setStx);
        this.maybeGet(recordFields, "STX_STRING").map(Function.identity()).ifPresent(record::setStxString);
        this.maybeGet(recordFields, "SUBMODE").map(Function.identity()).ifPresent(record::setSubmode);
        this.maybeGet(recordFields, "SWL").map(this::parseBool).ifPresent(record::setSwl);
        this.maybeGet(recordFields, "TEN_TEN").map(Integer::parseInt).ifPresent(record::setTenTen);
        this.maybeGet(recordFields, "TIME_OFF").map(this::parseTime).ifPresent(record::setTimeOff);
        this.maybeGet(recordFields, "TIME_ON").map(this::parseTime).ifPresent(record::setTimeOn);
        this.maybeGet(recordFields, "TX_PWR").map(s -> s.replaceAll("[wW]$", "")).filter(AdiReader::isNumeric).map(Double::parseDouble).ifPresent(record::setTxPwr);
        this.maybeGet(recordFields, "UKSMG").map(Integer::parseInt).ifPresent(record::setUksmg);
        this.maybeGet(recordFields, "USACA_COUNTIES").map(s -> this.parseColonArray((String)s, String::valueOf)).ifPresent(record::setUsaCaCounties);
        this.maybeGet(recordFields, "VUCC_GRIDS").map(s -> this.parseCommaArray((String)s, String::valueOf)).ifPresent(record::setVuccGrids);
        this.maybeGet(recordFields, "WEB").map(Function.identity()).ifPresent(record::setWeb);
        return record;
    }

    private <K, V> Optional<V> maybeGet(Map<K, V> map, K key) {
        this.current = key.toString();
        V res = map.get(key);
        return res == null ? Optional.empty() : Optional.of(res);
    }

    Map<String, String> readRecord(BufferedReader reader) throws IOException, EOFException {
        HashMap<String, String> fields = new HashMap<String, String>();
        Field field = this.readField(reader);
        if (field == null) {
            return null;
        }
        while (field != null && !"eor".equalsIgnoreCase(field.getName())) {
            fields.put(field.getName().toUpperCase(), field.getValue());
            field = this.readField(reader);
        }
        return fields;
    }

    private Tag parseTag(String tag) {
        String[] pieces = tag.substring(1, tag.length() - 1).split(":");
        return new Tag(pieces.length > 0 ? pieces[0] : null, pieces.length > 1 ? Integer.parseInt(pieces[1]) : 0, pieces.length > 2 ? pieces[2] : null);
    }

    Field readField(BufferedReader reader) throws EOFException, IOException {
        this.readUntil(reader, '<', false);
        String tag = this.readUntil(reader, '>', true);
        if (tag.isEmpty()) {
            return null;
        }
        Tag parsedTag = this.parseTag(tag);
        if (parsedTag.getLength() == 0) {
            return new Field(parsedTag.getName(), "");
        }
        int len = parsedTag.getLength();
        String value = this.readLength(reader, len);
        return new Field(parsedTag.getName(), value.trim());
    }

    private String readLength(BufferedReader reader, int len) throws IOException {
        char[] content = new char[len];
        int read = 0;
        while (read < len) {
            int res = reader.read(content, read, len - read);
            if (res >= 0) {
                read += res;
                continue;
            }
            read = len;
        }
        return String.copyValueOf(content);
    }

    AdifHeader readHeader(BufferedReader reader) throws IOException {
        AdifHeader header = new AdifHeader();
        while (true) {
            this.readUntil(reader, '<', false);
            String tag = this.readUntil(reader, '>', true);
            Tag parsedTag = this.parseTag(tag);
            String value = this.readLength(reader, parsedTag.getLength());
            if ("eoh".equalsIgnoreCase(parsedTag.getName())) break;
            if ("adif_ver".equalsIgnoreCase(parsedTag.getName())) {
                header.setVersion(value);
                continue;
            }
            if ("programid".equalsIgnoreCase(parsedTag.getName())) {
                header.setProgramId(value);
                continue;
            }
            if ("programversion".equalsIgnoreCase(parsedTag.getName())) {
                header.setProgramVersion(value);
                continue;
            }
            if (!"created_timestamp".equalsIgnoreCase(parsedTag.getName())) continue;
            header.setTimestamp(LocalDateTime.parse(value, DateTimeFormatter.ofPattern("yyyyMMdd HHmmss")).atZone(ZoneId.of("UTC")));
        }
        return header;
    }

    private String readUntil(Reader reader, char stop, boolean inclusive) throws IOException {
        reader.mark(1);
        int c = reader.read();
        StringBuilder builder = new StringBuilder();
        while (c != -1 && c != stop) {
            builder.append((char)c);
            reader.mark(1);
            c = reader.read();
        }
        if (c != -1 && inclusive) {
            builder.append((char)c);
        } else {
            reader.reset();
        }
        return builder.toString();
    }

    private ZonedDateTime parseDate(String s) {
        return LocalDate.parse(s, AdiWriter.dateFormatter).atStartOfDay(ZoneId.of("UTC"));
    }

    private LocalDate parseLocalDate(String s) {
        return LocalDate.parse(s, AdiWriter.dateFormatter);
    }

    private LocalTime parseTime(String s) {
        return LocalTime.parse(s, s.length() > 4 ? AdiWriter.timeFormatter : AdiWriter.timeFormatterShort);
    }

    private boolean parseBool(String s) {
        return s.equalsIgnoreCase("Y");
    }

    private <T> List<T> parseCommaArray(String s, Function<String, T> fieldConverter) {
        return Stream.of(s.split(",")).map(fieldConverter).collect(Collectors.toList());
    }

    private static boolean isNumeric(String s) {
        return NUMERIC_RE.matcher(s).matches();
    }

    private <T> List<T> parseColonArray(String s, Function<String, T> fieldConverter) {
        return Stream.of(s.split(":")).map(fieldConverter).collect(Collectors.toList());
    }

    static class Tag {
        String name;
        int length;
        String type;

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public String getType() {
            return this.type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLength() != other.getLength()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "AdiReader.Tag(name=" + this.getName() + ", length=" + this.getLength() + ", type=" + this.getType() + ")";
        }

        public Tag(String name, int length, String type) {
            this.name = name;
            this.length = length;
            this.type = type;
        }
    }

    static class Field {
        String name;
        String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AdiReader.Field(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        public Field(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

