/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.grid;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoordinateWriter {
    private static final Pattern LAT_RE = Pattern.compile("([NS]) ?([0-9]{0,3}) +([0-9]{1,2}(\\.[0-9]+)?)", 2);
    private static final Pattern LON_RE = Pattern.compile("([EW]) ?([01]?[0-9]{0,3}) +([0-9]{1,2}(\\.[0-9]+)?)", 2);
    private static final Pattern LAT_LOGOM_RE = Pattern.compile("([-]*[0-9]{0,3}\\.[0-9]+)", 2);
    private static final Pattern LON_LOGOM_RE = Pattern.compile("([-]*[0-9]{0,3}\\.[0-9]+)", 2);

    private static String getLatitudePrefix(Double lat) {
        return lat >= 0.0 ? "N" : "S";
    }

    private static String getLongitudePrefix(Double lat) {
        return lat >= 0.0 ? "E" : "W";
    }

    public static String lonToDM(double lon) {
        String prefix = CoordinateWriter.getLongitudePrefix(lon);
        return CoordinateWriter.coordToDM(prefix, lon);
    }

    public static String latToDM(double lat) {
        String prefix = CoordinateWriter.getLatitudePrefix(lat);
        return CoordinateWriter.coordToDM(prefix, lat);
    }

    private static String coordToDM(String prefix, double coord) {
        double absCoord = Math.abs(coord);
        int deg = (int)Math.floor(absCoord);
        double min = (absCoord - Math.floor(absCoord)) * 60.0;
        int wholeMin = (int)Math.floor(min);
        int remainder = (int)((min - (double)wholeMin) * 1000.0);
        return String.format("%s%03d %02d.%03d", prefix, deg, wholeMin, remainder);
    }

    public static double dmToLat(String string) {
        Matcher matcher = LAT_RE.matcher(string);
        Matcher matcherOm = LAT_LOGOM_RE.matcher(string);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            int deg = Integer.parseInt(matcher.group(2));
            double min = Double.parseDouble(matcher.group(3));
            return (double)(prefix.equalsIgnoreCase("N") ? 1 : -1) * ((double)deg + min / 60.0);
        }
        if (matcherOm.matches()) {
            return Double.parseDouble(matcherOm.group(1));
        }
        throw new IllegalArgumentException(String.format("Bad latitude format: '%s'", string));
    }

    public static double dmToLon(String string) {
        Matcher matcher = LON_RE.matcher(string);
        Matcher matcherOm = LON_LOGOM_RE.matcher(string);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            int deg = Integer.parseInt(matcher.group(2));
            double min = Double.parseDouble(matcher.group(3));
            return (double)(prefix.equalsIgnoreCase("E") ? 1 : -1) * ((double)deg + min / 60.0);
        }
        if (matcherOm.matches()) {
            return Double.parseDouble(matcherOm.group(1));
        }
        throw new IllegalArgumentException("Bad longitude format");
    }
}

