/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityReader;
import uk.m0nom.adifproc.activity.ActivityType;

public abstract class CsvActivityReader
extends ActivityReader {
    private static final Logger logger = Logger.getLogger(CsvActivityReader.class.getName());
    private int line = 0;

    public CsvActivityReader(ActivityType type, String sourceFile) {
        super(type, sourceFile);
    }

    public Map<String, Activity> readRecords(InputStream inputStream) throws IOException {
        HashMap<String, Activity> activityMap = new HashMap<String, Activity>();
        this.line = 0;
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(inputStream), StandardCharsets.UTF_8);
        CSVParser records = CSVFormat.EXCEL.withFirstRecordAsHeader().parse((Reader)reader);
        try {
            records.forEach(record -> {
                Activity info = this.readRecord((CSVRecord)record);
                activityMap.put(info.getRef(), info);
                ++this.line;
            });
        }
        catch (IllegalArgumentException e) {
            logger.severe(String.format("Error reading line %d: %s", this.line, e.getMessage()));
        }
        return activityMap;
    }

    @Override
    public ActivityDatabase read(InputStream reader) throws IOException {
        return new ActivityDatabase(ActivityType.SOTA, this.readRecords(reader));
    }

    protected abstract Activity readRecord(CSVRecord var1) throws IllegalArgumentException;
}

