/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity.cota;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.activity.cota.CotaCsvWriter;
import uk.m0nom.adifproc.activity.cota.CotaInfo;
import uk.m0nom.adifproc.coords.LocationParserResult;
import uk.m0nom.adifproc.coords.LocationParsingService;
import uk.m0nom.adifproc.coords.LocationSource;

public class CotaLocationProcessor {
    private static final Logger logger = Logger.getLogger(CotaLocationProcessor.class.getName());
    private static LocationParsingService locationParsingService = null;

    public static void main(String[] args) throws FileNotFoundException {
        ActivityDatabaseService summits = new ActivityDatabaseService();
        summits.loadData();
        locationParsingService = new LocationParsingService();
        int count = CotaLocationProcessor.extractLocationInformation(summits.getDatabase(ActivityType.COTA));
        logger.info(String.format("Found %d castle locations", count));
        new CotaCsvWriter().write(summits.getDatabase(ActivityType.COTA));
    }

    private static int extractLocationInformation(ActivityDatabase cotaDb) {
        Collection<Activity> values = cotaDb.getValues();
        int count = 0;
        for (Activity activity : values) {
            CotaInfo cota = (CotaInfo)activity;
            if (!CotaLocationProcessor.extractLocationInformation(cota)) continue;
            ++count;
        }
        return count;
    }

    private static boolean extractLocationInformation(CotaInfo cota) {
        LocationParserResult result;
        if (CotaLocationProcessor.isNotUrl(cota.getLocation()) && (result = locationParsingService.parseStringForCoordinates(LocationSource.ACTIVITY, cota.getLocation())) != null) {
            cota.setCoords(result.getCoords());
            return true;
        }
        if (CotaLocationProcessor.isNotUrl(cota.getInformation()) && (result = locationParsingService.parseStringForCoordinates(LocationSource.ACTIVITY, cota.getInformation())) != null) {
            cota.setCoords(result.getCoords());
            return true;
        }
        return false;
    }

    private static boolean isNotUrl(String str) {
        String toCheck = str.trim().toLowerCase(Locale.ROOT);
        return !toCheck.startsWith("http://") && !toCheck.startsWith("https://");
    }
}

