/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marsik.ham.adif.Adif3;
import uk.m0nom.adifproc.adif3.io.Adif3FileReader;
import uk.m0nom.adifproc.adif3.print.Adif3PrintFormatter;

public class PrintFormatApp
implements Runnable {
    private static final Logger logger = Logger.getLogger(PrintFormatApp.class.getName());
    private final Adif3PrintFormatter formatter;
    private final Adif3FileReader readerWriter;
    private final String[] args;

    public PrintFormatApp(String[] args) {
        this.args = args;
        this.formatter = new Adif3PrintFormatter();
        this.readerWriter = new Adif3FileReader();
    }

    public static void main(String[] args) {
        PrintFormatApp instance = new PrintFormatApp(args);
        instance.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        BufferedWriter writer = null;
        String in = "<unspecified>";
        String out = "<unspecified>";
        if (this.args.length != 2) {
            logger.config(String.format("Usage: %s <inputFile>.adi <config-file>.yaml", this.getClass().getName()));
        } else {
            in = this.args[0];
            out = String.format("%s.%s", FilenameUtils.removeExtension((String)in), "prn");
            this.formatter.getPrintJobConfig().configure(this.args[1], new FileInputStream(this.args[1]));
            Adif3 log = this.readerWriter.read(in, this.formatter.getPrintJobConfig().getInEncoding(), true);
            StringBuilder sb = this.formatter.format(log);
            File outFile = new File(out);
            if (outFile.delete()) {
                if (outFile.createNewFile()) {
                    writer = Files.newBufferedWriter(new File(out).toPath(), Charset.forName(this.formatter.getPrintJobConfig().getOutEncoding()), StandardOpenOption.WRITE);
                    writer.write(sb.toString());
                } else {
                    logger.severe(String.format("Error creating new file: %s", outFile.getAbsolutePath()));
                }
            } else {
                logger.severe(String.format("Error deleting file: %s", outFile.getAbsolutePath()));
            }
        }
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e) {
            logger.severe(String.format("Caught exception closing output file %s: %s", out, e.getMessage()));
            logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return;
        catch (IOException e) {
            try {
                logger.severe(String.format("Caught exception processing file: %s exception is:\n\t%s", in, e.getMessage()));
                logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
                if (writer == null) return;
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.severe(String.format("Caught exception closing output file %s: %s", out, e2.getMessage()));
                    logger.severe(ExceptionUtils.getStackTrace((Throwable)e2));
                }
                throw throwable;
            }
            try {
                writer.close();
                return;
            }
            catch (IOException e3) {
                logger.severe(String.format("Caught exception closing output file %s: %s", out, e3.getMessage()));
                logger.severe(ExceptionUtils.getStackTrace((Throwable)e3));
            }
            return;
        }
    }
}

