/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.contacts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.qrz.QrzCallsign;

public class Station {
    private String callsign;
    private QrzCallsign qrzInfo;
    private List<Qso> qsos;
    private Map<ActivityType, Activity> activities = new HashMap<ActivityType, Activity>();
    private String grid;
    private GlobalCoords3D coordinates;

    public Station() {
        this.qsos = new ArrayList<Qso>();
    }

    public Station(String callsign, Qso initialQso) {
        this();
        this.callsign = StringUtils.trim((String)callsign).toUpperCase();
        this.addQso(initialQso);
    }

    public void addQso(Qso qso) {
        this.qsos.add(qso);
    }

    public void addActivity(Activity activity) {
        if (activity != null) {
            this.activities.put(activity.getType(), activity);
        }
    }

    public boolean isDoing(ActivityType type) {
        return this.activities.containsKey((Object)type);
    }

    public Activity getActivity(ActivityType type) {
        return this.activities.get((Object)type);
    }

    public boolean hasActivity() {
        return this.activities.size() > 0;
    }

    public boolean doingSameActivityAs(Station other) {
        return this.activities.values().stream().anyMatch(a -> other.isDoing(a.getType()));
    }

    public boolean equals(Object other) {
        if (other instanceof Station) {
            return ((Station)other).getKey().equals(this.getKey());
        }
        return false;
    }

    public String getKey() {
        return String.format("%s %s %s", new Object[]{this.getCallsign(), this.getCoordinates(), this.getGrid()});
    }

    public String getCallsign() {
        return this.callsign;
    }

    public QrzCallsign getQrzInfo() {
        return this.qrzInfo;
    }

    public List<Qso> getQsos() {
        return this.qsos;
    }

    public Map<ActivityType, Activity> getActivities() {
        return this.activities;
    }

    public String getGrid() {
        return this.grid;
    }

    public GlobalCoords3D getCoordinates() {
        return this.coordinates;
    }

    public void setCallsign(String callsign) {
        this.callsign = callsign;
    }

    public void setQrzInfo(QrzCallsign qrzInfo) {
        this.qrzInfo = qrzInfo;
    }

    public void setQsos(List<Qso> qsos) {
        this.qsos = qsos;
    }

    public void setActivities(Map<ActivityType, Activity> activities) {
        this.activities = activities;
    }

    public void setGrid(String grid) {
        this.grid = grid;
    }

    public void setCoordinates(GlobalCoords3D coordinates) {
        this.coordinates = coordinates;
    }

    public String toString() {
        return "Station(callsign=" + this.getCallsign() + ", qrzInfo=" + this.getQrzInfo() + ", qsos=" + this.getQsos() + ", activities=" + this.getActivities() + ", grid=" + this.getGrid() + ", coordinates=" + this.getCoordinates() + ")";
    }
}

