/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.control;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.thymeleaf.TemplateEngine;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Element;
import uk.m0nom.adifproc.antenna.Antenna;
import uk.m0nom.adifproc.antenna.AntennaService;
import uk.m0nom.adifproc.dxcc.DxccEntities;

public class TransformControl {
    private long runTimestamp;
    private String location;
    private String pathname;
    private String outputPath;
    private String encoding;
    private String qrzUsername;
    private String qrzPassword;
    private boolean stripComment;
    private String printConfigFile;
    private Map<ActivityType, String> activityRefs = new HashMap<ActivityType, String>();
    private String satelliteName;
    private String satelliteMode;
    private String satelliteBand;
    private boolean sotaMicrowaveAwardComment;
    private Boolean generateKml;
    private Integer kmlContactWidth;
    private Integer kmlContactTransparency;
    private boolean kmlContactColourByBand;
    private boolean kmlS2s;
    private String kmlS2sContactLineStyle;
    private String kmlContactLineStyle;
    private String kmlSatelliteTrackLineStyle;
    private boolean kmlContactShadow;
    private boolean kmlShowStationSubLabel;
    private boolean kmlShowLocalActivationSites;
    private Double kmlLocalActivationSitesRadius;
    private boolean markdown;
    private boolean contestResults;
    private Antenna antenna = new AntennaService().getAntenna("Vertical");
    private Map<String, String> icons = new HashMap<String, String>();
    private Set<Adif3Element> adif3ElementSet;
    private TemplateEngine templateEngine;
    private DxccEntities dxccEntities;

    public String getActivityRef(ActivityType type) {
        return this.activityRefs.get((Object)type);
    }

    public String getIcon(String iconType) {
        return this.icons.get(iconType);
    }

    public void setIcon(String iconType, String iconUrl) {
        this.icons.put(iconType, iconUrl);
    }

    public void setActivityRef(ActivityType activity, String ref) {
        this.activityRefs.put(activity, ref);
    }

    public boolean hasQrzCredentials() {
        return StringUtils.isNotEmpty((CharSequence)this.qrzUsername) && StringUtils.isNotEmpty((CharSequence)this.qrzPassword);
    }

    public long getRunTimestamp() {
        return this.runTimestamp;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPathname() {
        return this.pathname;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getQrzUsername() {
        return this.qrzUsername;
    }

    public String getQrzPassword() {
        return this.qrzPassword;
    }

    public boolean isStripComment() {
        return this.stripComment;
    }

    public String getPrintConfigFile() {
        return this.printConfigFile;
    }

    public Map<ActivityType, String> getActivityRefs() {
        return this.activityRefs;
    }

    public String getSatelliteName() {
        return this.satelliteName;
    }

    public String getSatelliteMode() {
        return this.satelliteMode;
    }

    public String getSatelliteBand() {
        return this.satelliteBand;
    }

    public boolean isSotaMicrowaveAwardComment() {
        return this.sotaMicrowaveAwardComment;
    }

    public Boolean getGenerateKml() {
        return this.generateKml;
    }

    public Integer getKmlContactWidth() {
        return this.kmlContactWidth;
    }

    public Integer getKmlContactTransparency() {
        return this.kmlContactTransparency;
    }

    public boolean isKmlContactColourByBand() {
        return this.kmlContactColourByBand;
    }

    public boolean isKmlS2s() {
        return this.kmlS2s;
    }

    public String getKmlS2sContactLineStyle() {
        return this.kmlS2sContactLineStyle;
    }

    public String getKmlContactLineStyle() {
        return this.kmlContactLineStyle;
    }

    public String getKmlSatelliteTrackLineStyle() {
        return this.kmlSatelliteTrackLineStyle;
    }

    public boolean isKmlContactShadow() {
        return this.kmlContactShadow;
    }

    public boolean isKmlShowStationSubLabel() {
        return this.kmlShowStationSubLabel;
    }

    public boolean isKmlShowLocalActivationSites() {
        return this.kmlShowLocalActivationSites;
    }

    public Double getKmlLocalActivationSitesRadius() {
        return this.kmlLocalActivationSitesRadius;
    }

    public boolean isMarkdown() {
        return this.markdown;
    }

    public boolean isContestResults() {
        return this.contestResults;
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    public Map<String, String> getIcons() {
        return this.icons;
    }

    public Set<Adif3Element> getAdif3ElementSet() {
        return this.adif3ElementSet;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public DxccEntities getDxccEntities() {
        return this.dxccEntities;
    }

    public void setRunTimestamp(long runTimestamp) {
        this.runTimestamp = runTimestamp;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setQrzUsername(String qrzUsername) {
        this.qrzUsername = qrzUsername;
    }

    public void setQrzPassword(String qrzPassword) {
        this.qrzPassword = qrzPassword;
    }

    public void setStripComment(boolean stripComment) {
        this.stripComment = stripComment;
    }

    public void setPrintConfigFile(String printConfigFile) {
        this.printConfigFile = printConfigFile;
    }

    public void setActivityRefs(Map<ActivityType, String> activityRefs) {
        this.activityRefs = activityRefs;
    }

    public void setSatelliteName(String satelliteName) {
        this.satelliteName = satelliteName;
    }

    public void setSatelliteMode(String satelliteMode) {
        this.satelliteMode = satelliteMode;
    }

    public void setSatelliteBand(String satelliteBand) {
        this.satelliteBand = satelliteBand;
    }

    public void setSotaMicrowaveAwardComment(boolean sotaMicrowaveAwardComment) {
        this.sotaMicrowaveAwardComment = sotaMicrowaveAwardComment;
    }

    public void setGenerateKml(Boolean generateKml) {
        this.generateKml = generateKml;
    }

    public void setKmlContactWidth(Integer kmlContactWidth) {
        this.kmlContactWidth = kmlContactWidth;
    }

    public void setKmlContactTransparency(Integer kmlContactTransparency) {
        this.kmlContactTransparency = kmlContactTransparency;
    }

    public void setKmlContactColourByBand(boolean kmlContactColourByBand) {
        this.kmlContactColourByBand = kmlContactColourByBand;
    }

    public void setKmlS2s(boolean kmlS2s) {
        this.kmlS2s = kmlS2s;
    }

    public void setKmlS2sContactLineStyle(String kmlS2sContactLineStyle) {
        this.kmlS2sContactLineStyle = kmlS2sContactLineStyle;
    }

    public void setKmlContactLineStyle(String kmlContactLineStyle) {
        this.kmlContactLineStyle = kmlContactLineStyle;
    }

    public void setKmlSatelliteTrackLineStyle(String kmlSatelliteTrackLineStyle) {
        this.kmlSatelliteTrackLineStyle = kmlSatelliteTrackLineStyle;
    }

    public void setKmlContactShadow(boolean kmlContactShadow) {
        this.kmlContactShadow = kmlContactShadow;
    }

    public void setKmlShowStationSubLabel(boolean kmlShowStationSubLabel) {
        this.kmlShowStationSubLabel = kmlShowStationSubLabel;
    }

    public void setKmlShowLocalActivationSites(boolean kmlShowLocalActivationSites) {
        this.kmlShowLocalActivationSites = kmlShowLocalActivationSites;
    }

    public void setKmlLocalActivationSitesRadius(Double kmlLocalActivationSitesRadius) {
        this.kmlLocalActivationSitesRadius = kmlLocalActivationSitesRadius;
    }

    public void setMarkdown(boolean markdown) {
        this.markdown = markdown;
    }

    public void setContestResults(boolean contestResults) {
        this.contestResults = contestResults;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    public void setIcons(Map<String, String> icons) {
        this.icons = icons;
    }

    public void setAdif3ElementSet(Set<Adif3Element> adif3ElementSet) {
        this.adif3ElementSet = adif3ElementSet;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setDxccEntities(DxccEntities dxccEntities) {
        this.dxccEntities = dxccEntities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformControl)) {
            return false;
        }
        TransformControl other = (TransformControl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRunTimestamp() != other.getRunTimestamp()) {
            return false;
        }
        if (this.isStripComment() != other.isStripComment()) {
            return false;
        }
        if (this.isSotaMicrowaveAwardComment() != other.isSotaMicrowaveAwardComment()) {
            return false;
        }
        if (this.isKmlContactColourByBand() != other.isKmlContactColourByBand()) {
            return false;
        }
        if (this.isKmlS2s() != other.isKmlS2s()) {
            return false;
        }
        if (this.isKmlContactShadow() != other.isKmlContactShadow()) {
            return false;
        }
        if (this.isKmlShowStationSubLabel() != other.isKmlShowStationSubLabel()) {
            return false;
        }
        if (this.isKmlShowLocalActivationSites() != other.isKmlShowLocalActivationSites()) {
            return false;
        }
        if (this.isMarkdown() != other.isMarkdown()) {
            return false;
        }
        if (this.isContestResults() != other.isContestResults()) {
            return false;
        }
        Boolean this$generateKml = this.getGenerateKml();
        Boolean other$generateKml = other.getGenerateKml();
        if (this$generateKml == null ? other$generateKml != null : !((Object)this$generateKml).equals(other$generateKml)) {
            return false;
        }
        Integer this$kmlContactWidth = this.getKmlContactWidth();
        Integer other$kmlContactWidth = other.getKmlContactWidth();
        if (this$kmlContactWidth == null ? other$kmlContactWidth != null : !((Object)this$kmlContactWidth).equals(other$kmlContactWidth)) {
            return false;
        }
        Integer this$kmlContactTransparency = this.getKmlContactTransparency();
        Integer other$kmlContactTransparency = other.getKmlContactTransparency();
        if (this$kmlContactTransparency == null ? other$kmlContactTransparency != null : !((Object)this$kmlContactTransparency).equals(other$kmlContactTransparency)) {
            return false;
        }
        Double this$kmlLocalActivationSitesRadius = this.getKmlLocalActivationSitesRadius();
        Double other$kmlLocalActivationSitesRadius = other.getKmlLocalActivationSitesRadius();
        if (this$kmlLocalActivationSitesRadius == null ? other$kmlLocalActivationSitesRadius != null : !((Object)this$kmlLocalActivationSitesRadius).equals(other$kmlLocalActivationSitesRadius)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$pathname = this.getPathname();
        String other$pathname = other.getPathname();
        if (this$pathname == null ? other$pathname != null : !this$pathname.equals(other$pathname)) {
            return false;
        }
        String this$outputPath = this.getOutputPath();
        String other$outputPath = other.getOutputPath();
        if (this$outputPath == null ? other$outputPath != null : !this$outputPath.equals(other$outputPath)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        String this$qrzUsername = this.getQrzUsername();
        String other$qrzUsername = other.getQrzUsername();
        if (this$qrzUsername == null ? other$qrzUsername != null : !this$qrzUsername.equals(other$qrzUsername)) {
            return false;
        }
        String this$qrzPassword = this.getQrzPassword();
        String other$qrzPassword = other.getQrzPassword();
        if (this$qrzPassword == null ? other$qrzPassword != null : !this$qrzPassword.equals(other$qrzPassword)) {
            return false;
        }
        String this$printConfigFile = this.getPrintConfigFile();
        String other$printConfigFile = other.getPrintConfigFile();
        if (this$printConfigFile == null ? other$printConfigFile != null : !this$printConfigFile.equals(other$printConfigFile)) {
            return false;
        }
        Map<ActivityType, String> this$activityRefs = this.getActivityRefs();
        Map<ActivityType, String> other$activityRefs = other.getActivityRefs();
        if (this$activityRefs == null ? other$activityRefs != null : !((Object)this$activityRefs).equals(other$activityRefs)) {
            return false;
        }
        String this$satelliteName = this.getSatelliteName();
        String other$satelliteName = other.getSatelliteName();
        if (this$satelliteName == null ? other$satelliteName != null : !this$satelliteName.equals(other$satelliteName)) {
            return false;
        }
        String this$satelliteMode = this.getSatelliteMode();
        String other$satelliteMode = other.getSatelliteMode();
        if (this$satelliteMode == null ? other$satelliteMode != null : !this$satelliteMode.equals(other$satelliteMode)) {
            return false;
        }
        String this$satelliteBand = this.getSatelliteBand();
        String other$satelliteBand = other.getSatelliteBand();
        if (this$satelliteBand == null ? other$satelliteBand != null : !this$satelliteBand.equals(other$satelliteBand)) {
            return false;
        }
        String this$kmlS2sContactLineStyle = this.getKmlS2sContactLineStyle();
        String other$kmlS2sContactLineStyle = other.getKmlS2sContactLineStyle();
        if (this$kmlS2sContactLineStyle == null ? other$kmlS2sContactLineStyle != null : !this$kmlS2sContactLineStyle.equals(other$kmlS2sContactLineStyle)) {
            return false;
        }
        String this$kmlContactLineStyle = this.getKmlContactLineStyle();
        String other$kmlContactLineStyle = other.getKmlContactLineStyle();
        if (this$kmlContactLineStyle == null ? other$kmlContactLineStyle != null : !this$kmlContactLineStyle.equals(other$kmlContactLineStyle)) {
            return false;
        }
        String this$kmlSatelliteTrackLineStyle = this.getKmlSatelliteTrackLineStyle();
        String other$kmlSatelliteTrackLineStyle = other.getKmlSatelliteTrackLineStyle();
        if (this$kmlSatelliteTrackLineStyle == null ? other$kmlSatelliteTrackLineStyle != null : !this$kmlSatelliteTrackLineStyle.equals(other$kmlSatelliteTrackLineStyle)) {
            return false;
        }
        Antenna this$antenna = this.getAntenna();
        Antenna other$antenna = other.getAntenna();
        if (this$antenna == null ? other$antenna != null : !((Object)this$antenna).equals(other$antenna)) {
            return false;
        }
        Map<String, String> this$icons = this.getIcons();
        Map<String, String> other$icons = other.getIcons();
        if (this$icons == null ? other$icons != null : !((Object)this$icons).equals(other$icons)) {
            return false;
        }
        Set<Adif3Element> this$adif3ElementSet = this.getAdif3ElementSet();
        Set<Adif3Element> other$adif3ElementSet = other.getAdif3ElementSet();
        if (this$adif3ElementSet == null ? other$adif3ElementSet != null : !((Object)this$adif3ElementSet).equals(other$adif3ElementSet)) {
            return false;
        }
        TemplateEngine this$templateEngine = this.getTemplateEngine();
        TemplateEngine other$templateEngine = other.getTemplateEngine();
        if (this$templateEngine == null ? other$templateEngine != null : !this$templateEngine.equals(other$templateEngine)) {
            return false;
        }
        DxccEntities this$dxccEntities = this.getDxccEntities();
        DxccEntities other$dxccEntities = other.getDxccEntities();
        return !(this$dxccEntities == null ? other$dxccEntities != null : !this$dxccEntities.equals(other$dxccEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransformControl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $runTimestamp = this.getRunTimestamp();
        result = result * 59 + (int)($runTimestamp >>> 32 ^ $runTimestamp);
        result = result * 59 + (this.isStripComment() ? 79 : 97);
        result = result * 59 + (this.isSotaMicrowaveAwardComment() ? 79 : 97);
        result = result * 59 + (this.isKmlContactColourByBand() ? 79 : 97);
        result = result * 59 + (this.isKmlS2s() ? 79 : 97);
        result = result * 59 + (this.isKmlContactShadow() ? 79 : 97);
        result = result * 59 + (this.isKmlShowStationSubLabel() ? 79 : 97);
        result = result * 59 + (this.isKmlShowLocalActivationSites() ? 79 : 97);
        result = result * 59 + (this.isMarkdown() ? 79 : 97);
        result = result * 59 + (this.isContestResults() ? 79 : 97);
        Boolean $generateKml = this.getGenerateKml();
        result = result * 59 + ($generateKml == null ? 43 : ((Object)$generateKml).hashCode());
        Integer $kmlContactWidth = this.getKmlContactWidth();
        result = result * 59 + ($kmlContactWidth == null ? 43 : ((Object)$kmlContactWidth).hashCode());
        Integer $kmlContactTransparency = this.getKmlContactTransparency();
        result = result * 59 + ($kmlContactTransparency == null ? 43 : ((Object)$kmlContactTransparency).hashCode());
        Double $kmlLocalActivationSitesRadius = this.getKmlLocalActivationSitesRadius();
        result = result * 59 + ($kmlLocalActivationSitesRadius == null ? 43 : ((Object)$kmlLocalActivationSitesRadius).hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $pathname = this.getPathname();
        result = result * 59 + ($pathname == null ? 43 : $pathname.hashCode());
        String $outputPath = this.getOutputPath();
        result = result * 59 + ($outputPath == null ? 43 : $outputPath.hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        String $qrzUsername = this.getQrzUsername();
        result = result * 59 + ($qrzUsername == null ? 43 : $qrzUsername.hashCode());
        String $qrzPassword = this.getQrzPassword();
        result = result * 59 + ($qrzPassword == null ? 43 : $qrzPassword.hashCode());
        String $printConfigFile = this.getPrintConfigFile();
        result = result * 59 + ($printConfigFile == null ? 43 : $printConfigFile.hashCode());
        Map<ActivityType, String> $activityRefs = this.getActivityRefs();
        result = result * 59 + ($activityRefs == null ? 43 : ((Object)$activityRefs).hashCode());
        String $satelliteName = this.getSatelliteName();
        result = result * 59 + ($satelliteName == null ? 43 : $satelliteName.hashCode());
        String $satelliteMode = this.getSatelliteMode();
        result = result * 59 + ($satelliteMode == null ? 43 : $satelliteMode.hashCode());
        String $satelliteBand = this.getSatelliteBand();
        result = result * 59 + ($satelliteBand == null ? 43 : $satelliteBand.hashCode());
        String $kmlS2sContactLineStyle = this.getKmlS2sContactLineStyle();
        result = result * 59 + ($kmlS2sContactLineStyle == null ? 43 : $kmlS2sContactLineStyle.hashCode());
        String $kmlContactLineStyle = this.getKmlContactLineStyle();
        result = result * 59 + ($kmlContactLineStyle == null ? 43 : $kmlContactLineStyle.hashCode());
        String $kmlSatelliteTrackLineStyle = this.getKmlSatelliteTrackLineStyle();
        result = result * 59 + ($kmlSatelliteTrackLineStyle == null ? 43 : $kmlSatelliteTrackLineStyle.hashCode());
        Antenna $antenna = this.getAntenna();
        result = result * 59 + ($antenna == null ? 43 : ((Object)$antenna).hashCode());
        Map<String, String> $icons = this.getIcons();
        result = result * 59 + ($icons == null ? 43 : ((Object)$icons).hashCode());
        Set<Adif3Element> $adif3ElementSet = this.getAdif3ElementSet();
        result = result * 59 + ($adif3ElementSet == null ? 43 : ((Object)$adif3ElementSet).hashCode());
        TemplateEngine $templateEngine = this.getTemplateEngine();
        result = result * 59 + ($templateEngine == null ? 43 : $templateEngine.hashCode());
        DxccEntities $dxccEntities = this.getDxccEntities();
        result = result * 59 + ($dxccEntities == null ? 43 : $dxccEntities.hashCode());
        return result;
    }

    public String toString() {
        return "TransformControl(runTimestamp=" + this.getRunTimestamp() + ", location=" + this.getLocation() + ", pathname=" + this.getPathname() + ", outputPath=" + this.getOutputPath() + ", encoding=" + this.getEncoding() + ", qrzUsername=" + this.getQrzUsername() + ", qrzPassword=" + this.getQrzPassword() + ", stripComment=" + this.isStripComment() + ", printConfigFile=" + this.getPrintConfigFile() + ", activityRefs=" + this.getActivityRefs() + ", satelliteName=" + this.getSatelliteName() + ", satelliteMode=" + this.getSatelliteMode() + ", satelliteBand=" + this.getSatelliteBand() + ", sotaMicrowaveAwardComment=" + this.isSotaMicrowaveAwardComment() + ", generateKml=" + this.getGenerateKml() + ", kmlContactWidth=" + this.getKmlContactWidth() + ", kmlContactTransparency=" + this.getKmlContactTransparency() + ", kmlContactColourByBand=" + this.isKmlContactColourByBand() + ", kmlS2s=" + this.isKmlS2s() + ", kmlS2sContactLineStyle=" + this.getKmlS2sContactLineStyle() + ", kmlContactLineStyle=" + this.getKmlContactLineStyle() + ", kmlSatelliteTrackLineStyle=" + this.getKmlSatelliteTrackLineStyle() + ", kmlContactShadow=" + this.isKmlContactShadow() + ", kmlShowStationSubLabel=" + this.isKmlShowStationSubLabel() + ", kmlShowLocalActivationSites=" + this.isKmlShowLocalActivationSites() + ", kmlLocalActivationSitesRadius=" + this.getKmlLocalActivationSitesRadius() + ", markdown=" + this.isMarkdown() + ", contestResults=" + this.isContestResults() + ", antenna=" + this.getAntenna() + ", icons=" + this.getIcons() + ", adif3ElementSet=" + this.getAdif3ElementSet() + ", templateEngine=" + this.getTemplateEngine() + ", dxccEntities=" + this.getDxccEntities() + ")";
    }
}

