/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Optional;
import java.util.TreeSet;
import org.marsik.ham.adif.AdiReader;
import org.marsik.ham.adif.Adif3;
import org.marsik.ham.adif.Adif3Record;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.adif3.io.Adif3RecordTimestampComparator;
import uk.m0nom.adifproc.qsofile.QsoFileReader;

@Service
public class Adif3FileReader
implements QsoFileReader {
    @Override
    public Adif3 read(String filename, String encoding, boolean sort) throws IOException {
        AdiReader reader = new AdiReader();
        BufferedReader inputReader = Files.newBufferedReader(new File(filename).toPath(), Charset.forName(encoding));
        Optional<Adif3> result = reader.read(inputReader);
        if (result.isPresent()) {
            Adif3 adif = result.get();
            if (sort) {
                int unsortedRecords = adif.getRecords().size();
                TreeSet<Adif3Record> sortedRecords = new TreeSet<Adif3Record>(new Adif3RecordTimestampComparator());
                sortedRecords.addAll(adif.getRecords());
                ArrayList<Adif3Record> sortedRecordList = new ArrayList<Adif3Record>(sortedRecords);
                assert (sortedRecordList.size() == unsortedRecords);
                adif.setRecords(sortedRecordList);
            }
            return adif;
        }
        return null;
    }
}

