/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform;

import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.activity.wota.WotaInfo;
import uk.m0nom.adifproc.activity.wota.WotaSummitsDatabase;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.qrz.CachingQrzXmlService;

@Service
public class ActivityProcessor {
    protected final CachingQrzXmlService qrzXmlService;
    protected final ActivityDatabaseService activities;

    public ActivityProcessor(CachingQrzXmlService qrzXmlService, ActivityDatabaseService activities) {
        this.qrzXmlService = qrzXmlService;
        this.activities = activities;
    }

    protected void setHemaOrSotaFromWota(Station station, String wotaId) {
        WotaInfo wotaInfo = (WotaInfo)this.activities.getDatabase(ActivityType.WOTA).get(wotaId);
        station.addActivity(this.activities.getDatabase(ActivityType.HEMA).get(wotaInfo.getHemaId()));
        station.addActivity(this.activities.getDatabase(ActivityType.SOTA).get(wotaInfo.getSotaId()));
    }

    protected void setWotaFromHemaId(Station station, String hemaId) {
        WotaSummitsDatabase wotaDatabase = (WotaSummitsDatabase)this.activities.getDatabase(ActivityType.WOTA);
        station.addActivity(wotaDatabase.getFromHemaId(hemaId));
    }

    protected void setWotaFromSotaId(Station station, String sotaId) {
        WotaSummitsDatabase wotaDatabase = (WotaSummitsDatabase)this.activities.getDatabase(ActivityType.WOTA);
        station.addActivity(wotaDatabase.getFromSotaId(sotaId));
    }

    protected void processActivityFromControl(TransformControl control, ActivityType type, Station station) {
        String ref = control.getActivityRef(type);
        if (StringUtils.isNotBlank((CharSequence)ref)) {
            ref = ref.toUpperCase();
            this.processActivity(type, station, ref);
        }
    }

    protected void processActivity(ActivityType type, Station station, String ref) {
        station.addActivity(this.activities.getDatabase(type).get(ref.toUpperCase()));
        switch (type) {
            case WOTA: {
                this.setHemaOrSotaFromWota(station, ref);
                break;
            }
            case SOTA: {
                this.setWotaFromSotaId(station, ref);
                break;
            }
            case HEMA: {
                this.setWotaFromHemaId(station, ref);
            }
        }
    }

    protected void processActivityFromSigInfo(ActivityType type, Station station, Adif3Record rec) {
        String sigInfo;
        String sig = rec.getMySig();
        if (sig == null) {
            sig = rec.getMySigIntl();
        }
        if ((sigInfo = rec.getMySigInfo()) == null) {
            sigInfo = rec.getMySigInfoIntl();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type.getActivityName(), (CharSequence)sig) && StringUtils.isNotBlank((CharSequence)sigInfo)) {
            this.processActivity(type, station, sigInfo);
        }
    }

    public void processActivities(TransformControl control, Station station, Adif3Record rec) {
        for (ActivityType activity : ActivityType.values()) {
            this.processActivityFromSigInfo(activity, station, rec);
            this.processActivityFromControl(control, activity, station);
            this.processSpecialEventActivity(activity, station);
        }
    }

    private void processSpecialEventActivity(ActivityType type, Station station) {
        Activity activity;
        ActivityDatabase db = this.activities.getDatabase(type);
        if (db.isSpecialEventActivity() && (activity = db.get(station.getCallsign().toUpperCase().trim())) != null) {
            station.addActivity(activity);
        }
    }
}

